/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.test;

import com.thaiopensource.datatype.xsd.regex.Regex;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Service;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.util.Utf16;
import java.io.IOException;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TestDriver
extends DefaultHandler {
    private final StringBuffer buf = new StringBuffer();
    private Regex regex;
    private int nFail = 0;
    private int nTests = 0;
    private Locator loc;
    private final RegexEngine engine;
    private static final String ERROR_MARKER = ">>>>";

    public static void main(String[] args) throws SAXException, IOException, ParserConfigurationException {
        RegexEngine engine;
        if (args.length != 2) {
            System.err.println("usage: TestDriver class testfile");
            System.exit(2);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XMLReader xr = factory.newSAXParser().getXMLReader();
        Enumeration e = new Service(RegexEngine.class).getProviders();
        do {
            if (e.hasMoreElements()) continue;
            System.err.println("couldn't find regex engine");
            System.exit(2);
        } while (!(engine = (RegexEngine)e.nextElement()).getClass().getName().equals(args[0]));
        TestDriver tester = new TestDriver(engine);
        xr.setContentHandler(tester);
        InputSource in = new InputSource(UriOrFile.fileToUri(args[1]));
        xr.parse(in);
        System.err.println(tester.nTests + " tests performed");
        System.err.println(tester.nFail + " failures");
        if (tester.nFail > 0) {
            System.exit(1);
        }
    }

    public TestDriver(RegexEngine engine) {
        this.engine = engine;
    }

    public void setDocumentLocator(Locator locator) {
        this.loc = locator;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buf.append(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.buf.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.buf.setLength(0);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("valid")) {
            this.valid(this.buf.toString());
        } else if (localName.equals("invalid")) {
            this.invalid(this.buf.toString());
        } else if (localName.equals("correct")) {
            this.correct(this.buf.toString());
        } else if (localName.equals("incorrect")) {
            this.incorrect(this.buf.toString());
        }
    }

    private void correct(String str) {
        ++this.nTests;
        this.regex = null;
        try {
            this.regex = this.engine.compile(str);
        }
        catch (RegexSyntaxException e) {
            this.error("unexpected error: " + e.getMessage() + ": " + TestDriver.display(str, e.getPosition()));
        }
    }

    private void incorrect(String str) {
        ++this.nTests;
        this.regex = null;
        try {
            this.engine.compile(str);
            this.error("failed to detect error in regex: " + TestDriver.display(str, -1));
        }
        catch (RegexSyntaxException regexSyntaxException) {
            // empty catch block
        }
    }

    private void valid(String str) {
        if (this.regex == null) {
            return;
        }
        ++this.nTests;
        if (!this.regex.matches(str)) {
            this.error("match failed for string: " + TestDriver.display(str, -1));
        }
    }

    private void invalid(String str) {
        if (this.regex == null) {
            return;
        }
        ++this.nTests;
        if (this.regex.matches(str)) {
            this.error("match incorrectly succeeded for string: " + TestDriver.display(str, -1));
        }
    }

    private void error(String str) {
        int line = -1;
        if (this.loc != null) {
            line = this.loc.getLineNumber();
        }
        if (line >= 0) {
            System.err.print("Line " + line + ": ");
        }
        System.err.println(str);
        ++this.nFail;
    }

    static String display(String str, int pos) {
        StringBuffer buf = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c;
            if (i == pos) {
                buf.append(ERROR_MARKER);
            }
            if (Utf16.isSurrogate1(c = str.charAt(i))) {
                buf.append("&#x" + Integer.toHexString(Utf16.scalarValue(c, str.charAt(++i))) + ";");
                continue;
            }
            if (c < ' ' || c >= '\u007f') {
                buf.append("&#x" + Integer.toHexString(c) + ";");
                continue;
            }
            if (c == '&') {
                buf.append("&amp;");
                continue;
            }
            buf.append(c);
        }
        if (str.length() == pos) {
            buf.append(ERROR_MARKER);
        }
        return buf.toString();
    }
}

