/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.frames;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.event.AttributeChangedEvent;
import org.w3c.util.CountInputStream;
import org.w3c.www.http.HeaderDescription;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.http.MimeParserReplyFactory;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserException;

public class AsIsFrame
extends HTTPFrame {
    int foffset = -1;
    HttpReplyMessage asisreply = null;

    public void attributeChanged(AttributeChangedEvent attributeChangedEvent) {
        super.attributeChanged(attributeChangedEvent);
        this.asisreply = null;
    }

    protected void updateCachedHeaders() {
        super.updateCachedHeaders();
        if (this.asisreply == null && this.fresource != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.fresource.getFile());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            CountInputStream countInputStream = new CountInputStream(fileInputStream);
            MimeParserReplyFactory mimeParserReplyFactory = new MimeParserReplyFactory();
            MimeParser mimeParser = new MimeParser(countInputStream, mimeParserReplyFactory);
            try {
                this.asisreply = (HttpReplyMessage)mimeParser.parse();
            }
            catch (MimeParserException mimeParserException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
            this.foffset = (int)countInputStream.getBytesRead();
            try {
                countInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = this.fresource.getFileLength();
            this.setValue(ATTR_CONTENT_LENGTH, (Object)new Integer(n -= this.foffset));
            this.contentlength = HttpFactory.makeInteger(n);
            this.md5Digest = null;
        }
    }

    public Reply createDefaultReply(Request request, int n) {
        if (this.asisreply == null) {
            this.updateCachedHeaders();
        }
        if (this.asisreply == null) {
            return super.createDefaultReply(request, n);
        }
        Reply reply = super.createDefaultReply(request, this.asisreply.getStatus());
        reply.setReason(this.asisreply.getReason());
        Enumeration enumeration = this.asisreply.enumerateHeaderDescriptions();
        while (enumeration.hasMoreElements()) {
            HeaderDescription headerDescription = (HeaderDescription)enumeration.nextElement();
            HeaderValue headerValue = this.asisreply.getHeaderValue(headerDescription);
            if (headerValue == null) continue;
            reply.setHeaderValue(headerDescription, headerValue);
        }
        return reply;
    }

    protected Reply createFileReply(Request request) throws ProtocolException, ResourceException {
        File file = this.fresource.getFile();
        Reply reply = null;
        reply = this.createDefaultReply(request, 200);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.skip(this.foffset);
            reply.setStream(fileInputStream);
        }
        catch (IOException iOException) {
            Reply reply2 = request.makeReply(503);
            reply2.setContent(iOException.getMessage());
            return reply2;
        }
        return reply;
    }
}

