/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.webdav;

import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.webdav.DAVStatusURI;
import org.w3c.www.webdav.DAVStatusURIList;
import org.w3c.www.webdav.WEBDAV;

public class DAVReply
extends Reply
implements WEBDAV {
    public void setLockToken(String string) {
        this.setHeaderValue("Lock-Token", (HeaderValue)HttpFactory.makeString(string));
    }

    public String getLockToken() {
        HeaderValue headerValue = this.getHeaderValue("Lock-Token");
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public void setStatusURI(int n, String string) {
        DAVStatusURIList dAVStatusURIList = (DAVStatusURIList)this.getHeaderValue("Status-URI");
        DAVStatusURI dAVStatusURI = new DAVStatusURI(n, string);
        if (dAVStatusURIList == null) {
            dAVStatusURIList = new DAVStatusURIList(dAVStatusURI);
        } else {
            dAVStatusURIList.addStatusURI(dAVStatusURI);
        }
        this.setHeaderValue("Status-URI", (HeaderValue)dAVStatusURIList);
    }

    public DAVStatusURI[] getStatusURI() {
        HeaderValue headerValue = this.getHeaderValue("Status-URI");
        return headerValue != null ? (DAVStatusURI[])headerValue.getValue() : null;
    }

    public void setDAV(String string) {
        this.setHeaderValue("DAV", (HeaderValue)HttpFactory.makeString(string));
    }

    protected void setFilters(ResourceFilter[] resourceFilterArray, int n) {
        super.setFilters(resourceFilterArray, n);
    }

    public String getStandardReason(int n) {
        return DAVReply.getDAVReason(n);
    }

    public static String getDAVReason(int n) {
        int n2 = n / 100;
        int n3 = n % 100;
        switch (n2) {
            case 1: {
                if (n3 < 0 || n3 >= WEBDAV.dav_msg_100.length) break;
                return WEBDAV.dav_msg_100[n3];
            }
            case 2: {
                if (n3 < 0 || n3 >= WEBDAV.dav_msg_200.length) break;
                return WEBDAV.dav_msg_200[n3];
            }
            case 3: {
                if (n3 < 0 || n3 >= WEBDAV.dav_msg_300.length) break;
                return WEBDAV.dav_msg_300[n3];
            }
            case 4: {
                if (n3 < 0 || n3 >= WEBDAV.dav_msg_400.length) break;
                return WEBDAV.dav_msg_400[n3];
            }
            case 5: {
                if (n3 < 0 || n3 >= WEBDAV.dav_msg_500.length) break;
                return WEBDAV.dav_msg_500[n3];
            }
        }
        return null;
    }

    public DAVReply(Client client, Request request, short s, short s2, int n) {
        super(client, request, s, s2, n);
    }

    static {
        DAVReply.registerHeader("DAV", "org.w3c.www.http.HttpString");
        DAVReply.registerHeader("Lock-Token", "org.w3c.www.http.HttpString");
        DAVReply.registerHeader("Status-URI", "org.w3c.www.webdav.DAVStatusURIList");
    }
}

