/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.jigsaw.zip.ZipInputStream;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FileAttribute;
import org.w3c.tools.resources.FileResource;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.StringAttribute;

public class ZipFileResource
extends FileResource {
    protected static int ATTR_ZIPFILE = -1;
    protected static int ATTR_ENTRYPATH = -1;

    public synchronized File getFile() {
        return (File)this.getValue(ATTR_ZIPFILE, null);
    }

    public String getEntryPath() {
        return this.getString(ATTR_ENTRYPATH, null);
    }

    protected synchronized InputStream getInputStream() {
        try {
            ZipFile zipFile = new ZipFile(this.getFile());
            ZipEntry zipEntry = zipFile.getEntry(this.getEntryPath());
            return new ZipInputStream(zipFile, zipFile.getInputStream(zipEntry));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized long getEntrySize() {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.getFile());
            ZipEntry zipEntry = zipFile.getEntry(this.getEntryPath());
            if (zipEntry != null) {
                long l = zipEntry.getSize();
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (IOException iOException) {
            long l = 0L;
            return l;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean hasEntry() {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.getFile());
            boolean bl = zipFile.getEntry(this.getEntryPath()) != null;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception exception) {}
        }
    }

    public void updateFileAttributes() {
        File file = this.getFile();
        this.setValue(ATTR_FILESTAMP, (Object)new Long(file.lastModified()));
        this.setValue(ATTR_FILE_LENGTH, (Object)new Integer((int)this.getEntrySize()));
    }

    public synchronized boolean verify() {
        File file = this.getFile();
        if (!file.exists()) {
            return false;
        }
        return this.hasEntry();
    }

    public synchronized boolean newContent(InputStream inputStream) throws IOException {
        throw new IOException("Can't modify the content of ZipFile");
    }

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.zip.ZipFileResource");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        simpleAttribute = new FileAttribute("zipfile", null, 1);
        ATTR_ZIPFILE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new StringAttribute("entrypath", null, 1);
        ATTR_ENTRYPATH = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }
}

