/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpAcceptLanguageList;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpAcceptLanguage
extends BasicValue {
    String language = null;
    double quality = 1.0;
    HttpAcceptLanguageList list = null;

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        parseState.separator = (byte)59;
        parseState.spaceIsSep = false;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("Invalid Accept-Language: no language.");
        }
        this.language = new String(this.raw, 0, parseState.start, parseState.end - parseState.start);
        parseState.prepare();
        parseState.separator = (byte)61;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.quality = 1.0;
        } else {
            parseState.prepare();
            this.quality = HttpParser.parseQuality(this.raw, parseState);
        }
    }

    protected void invalidateByteValue() {
        super.invalidateByteValue();
        if (this.list != null) {
            this.list.invalidateByteValue();
        }
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.append(this.language);
        httpBuffer.append(';');
        httpBuffer.append(this.quality);
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    public String getLanguage() {
        this.validate();
        return this.language;
    }

    public void setLanguage(String string) {
        if (this.language.equals(string)) {
            return;
        }
        this.invalidateByteValue();
        this.language = string;
    }

    public double getQuality() {
        this.validate();
        return this.quality;
    }

    public void setQuality(double d) {
        if (this.quality != d) {
            this.invalidateByteValue();
        }
        this.quality = d;
    }

    HttpAcceptLanguage(HttpAcceptLanguageList httpAcceptLanguageList, byte[] byArray, int n, int n2) {
        this.list = httpAcceptLanguageList;
        this.raw = byArray;
        this.roff = n;
        this.rlen = n2;
        this.isValid = false;
    }

    HttpAcceptLanguage(boolean bl, String string, double d) {
        this.isValid = bl;
        this.setLanguage(string);
        this.setQuality(d);
    }

    public HttpAcceptLanguage() {
        this.isValid = false;
    }
}

