/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.micp;

import org.w3c.www.protocol.http.micp.MICP;
import org.w3c.www.protocol.http.micp.MICPMessage;
import org.w3c.www.protocol.http.micp.MICPProtocolException;

public class MICPReadWrite
implements MICP {
    private final void encodeShort(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)((n2 & 0xFF00) >>> 8);
        byArray[n + 1] = (byte)(n2 & 0xFF);
    }

    private final int decodeShort(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 8) + (byArray[n + 1] & 0xFF);
    }

    private final void encodeInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)((n2 & 0xFF000000) >>> 24);
        byArray[n + 1] = (byte)((n2 & 0xFF0000) >>> 16);
        byArray[n + 2] = (byte)((n2 & 0xFF00) >>> 8);
        byArray[n + 3] = (byte)((n2 & 0xFF0000FF) >>> 0);
    }

    private final int decodeInt(byte[] byArray, int n) {
        return ((byArray[n] & 0xFF) << 24) + ((byArray[n + 1] & 0xFF) << 16) + ((byArray[n + 2] & 0xFF) << 8) + (byArray[n + 3] & 0xFF);
    }

    private final void encodeString(byte[] byArray, int n, String string) {
        byte[] byArray2 = string.getBytes();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public MICPMessage decode(byte[] byArray, int n, MICPMessage mICPMessage) throws MICPProtocolException {
        if (n < 12) {
            throw new MICPProtocolException("invalid buffer length " + n);
        }
        int n2 = this.decodeShort(byArray, 2);
        if (n < n2) {
            throw new MICPProtocolException("invalid length " + n2 + "/" + n);
        }
        mICPMessage.version = byArray[0] & 0xFF;
        mICPMessage.op = byArray[1] & 0xFF;
        mICPMessage.src = this.decodeInt(byArray, 4);
        mICPMessage.id = this.decodeInt(byArray, 8);
        mICPMessage.url = new String(byArray, 12, n - 12);
        return mICPMessage;
    }

    public int encode(int n, int n2, int n3, String string, byte[] byArray) {
        int n4 = 12 + string.length();
        if (n4 >= byArray.length) {
            return -n4;
        }
        byArray[0] = 1;
        byArray[1] = (byte)(n & 0xFF);
        this.encodeShort(byArray, 2, n4);
        this.encodeInt(byArray, 4, n2);
        this.encodeInt(byArray, 8, n3);
        this.encodeString(byArray, 12, string);
        return n4;
    }
}

