/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.EncryptionHandler;
import com.adobe.epubcheck.ocf.OCFData;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFData;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.util.OPSType;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class OCFChecker {
    OCFPackage ocf;
    Report report;
    static XMLValidator containerValidator = new XMLValidator("schema/20/rng/container.rng");
    static XMLValidator encryptionValidator = new XMLValidator("schema/20/rng/encryption.rng");
    static XMLValidator signatureValidator = new XMLValidator("schema/20/rng/signatures.rng");
    static XMLValidator containerValidator30 = new XMLValidator("schema/30/ocf-container-30.rnc");
    static XMLValidator encryptionValidator30 = new XMLValidator("schema/30/ocf-encryption-30.rnc");
    static XMLValidator signatureValidator30 = new XMLValidator("schema/30/ocf-signatures-30.rnc");
    private static HashMap<OPSType, XMLValidator> xmlValidatorMap;

    public OCFChecker(OCFPackage ocf, Report report) {
        this.ocf = ocf;
        this.report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runChecks() {
        if (!this.ocf.hasEntry("META-INF/container.xml")) {
            this.report.error(null, 0, 0, "Required META-INF/container.xml resource is missing");
            return;
        }
        OCFData containerHandler = this.ocf.getOcfData(this.report);
        String rootPath = containerHandler.getRootPath();
        if (rootPath != null) {
            if (this.ocf.hasEntry(rootPath)) {
                InputStream mimetype = null;
                try {
                    OPFData opfHandler = this.ocf.getOpfData(containerHandler, this.report);
                    System.out.println("Validating against EPUB version " + (Object)((Object)opfHandler.getVersion()));
                    mimetype = this.ocf.getInputStream("mimetype");
                    if (this.ocf.hasEntry("mimetype") && !CheckUtil.checkTrailingSpaces(mimetype, opfHandler.getVersion())) {
                        this.report.error("mimetype", 0, 0, "Mimetype file should contain only the string \"application/epub+zip\".");
                    }
                    this.validate(opfHandler.getVersion());
                    OPFChecker opfChecker = opfHandler.getVersion() == EPUBVersion.VERSION_2 ? new OPFChecker(this.ocf, this.report, rootPath, containerHandler.getContainerEntries(), opfHandler.getVersion()) : new OPFChecker30(this.ocf, this.report, rootPath, containerHandler.getContainerEntries(), opfHandler.getVersion());
                    opfChecker.runChecks();
                }
                catch (InvalidVersionException e) {
                    this.report.error(rootPath, -1, -1, e.getMessage());
                }
                catch (IOException ignore) {
                }
                finally {
                    try {
                        mimetype.close();
                    }
                    catch (Exception e) {}
                }
            } else {
                this.report.error("META-INF/container.xml", -1, -1, "entry " + rootPath + " not found in zip file");
            }
        } else {
            this.report.error("META-INF/container.xml", -1, -1, "No rootfiles with media type 'application/oebps-package+xml'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(EPUBVersion version) {
        XMLParser parser = null;
        InputStream in = null;
        try {
            in = this.ocf.getInputStream("META-INF/container.xml");
            parser = new XMLParser(in, "META-INF/container.xml", "xml", this.report, version);
            XMLHandler handler = new OCFHandler(parser);
            parser.addXMLHandler(handler);
            parser.addValidator(xmlValidatorMap.get(new OPSType("META-INF/container.xml", version)));
            parser.process();
            try {
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.ocf.hasEntry("META-INF/encryption.xml")) {
                in = this.ocf.getInputStream("META-INF/encryption.xml");
                parser = new XMLParser(in, "META-INF/encryption.xml", "xml", this.report, version);
                handler = new EncryptionHandler(this.ocf, parser);
                parser.addXMLHandler(handler);
                parser.addValidator(xmlValidatorMap.get(new OPSType("META-INF/encryption.xml", version)));
                parser.process();
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.ocf.hasEntry("META-INF/signatures.xml")) {
                in = this.ocf.getInputStream("META-INF/signatures.xml");
                parser = new XMLParser(in, "META-INF/signatures.xml", "xml", this.report, version);
                handler = new OCFHandler(parser);
                parser.addXMLHandler(handler);
                parser.addValidator(xmlValidatorMap.get(new OPSType("META-INF/signatures.xml", version)));
                parser.process();
                try {
                    in.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception ignore) {
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return false;
    }

    public String processRootPath(String rootPath) {
        String rootBase = rootPath;
        if (rootPath.endsWith(".opf")) {
            int slash = rootPath.lastIndexOf("/");
            if (slash < rootPath.lastIndexOf("\\")) {
                slash = rootPath.lastIndexOf("\\");
            }
            rootBase = slash >= 0 && slash + 1 < rootPath.length() ? rootPath.substring(0, slash + 1) : rootPath;
            return rootBase;
        }
        System.out.println("RootPath is not an OPF file");
        return null;
    }

    static {
        HashMap<OPSType, XMLValidator> map = new HashMap<OPSType, XMLValidator>();
        map.put(new OPSType("META-INF/container.xml", EPUBVersion.VERSION_2), containerValidator);
        map.put(new OPSType("META-INF/container.xml", EPUBVersion.VERSION_3), containerValidator30);
        map.put(new OPSType("META-INF/encryption.xml", EPUBVersion.VERSION_2), encryptionValidator);
        map.put(new OPSType("META-INF/encryption.xml", EPUBVersion.VERSION_3), encryptionValidator30);
        map.put(new OPSType("META-INF/signatures.xml", EPUBVersion.VERSION_2), signatureValidator);
        map.put(new OPSType("META-INF/signatures.xml", EPUBVersion.VERSION_3), signatureValidator30);
        xmlValidatorMap = map;
    }
}

