/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.IByteArrayDecoder;
import com.phloc.commons.io.streams.NonBlockingByteArrayOutputStream;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import javax.annotation.Nullable;

public final class ASCIIHexCodec
implements IByteArrayDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] aEncodedBuffer) {
        if (aEncodedBuffer == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream aBAOS = new NonBlockingByteArrayOutputStream();
        try {
            boolean bFirstByte = true;
            int nFirstByte = 0;
            for (byte nEncByte : aEncodedBuffer) {
                if (nEncByte == 62) break;
                if (Character.isWhitespace(nEncByte)) continue;
                byte nDecByte = (byte)StringHelper.getHexValue((char)nEncByte);
                if (nDecByte == -1) {
                    throw new DecoderException("Failed to convert byte '" + nEncByte + "/" + (char)nEncByte + "' to hex value in ASCIIHexDecode");
                }
                if (bFirstByte) {
                    nFirstByte = nDecByte;
                } else {
                    aBAOS.write((byte)(nFirstByte << 4 | nDecByte));
                }
                bFirstByte = !bFirstByte;
            }
            if (!bFirstByte) {
                aBAOS.write((byte)(nFirstByte << 4));
            }
            byte[] byArray = aBAOS.toByteArray();
            return byArray;
        }
        finally {
            StreamUtils.close(aBAOS);
        }
    }
}

