/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import java.io.IOException;
import java.io.Reader;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NonBlockingStringReader
extends Reader {
    private String m_sStr;
    private final int m_nLength;
    private int m_nNext = 0;
    private int m_nMark = 0;

    public NonBlockingStringReader(@Nonnull char[] aChars) {
        this(new String(aChars));
    }

    public NonBlockingStringReader(@Nonnull char[] aChars, int nOfs, int nLength) {
        this(new String(aChars, nOfs, nLength));
    }

    public NonBlockingStringReader(@Nonnull String sStr) {
        if (sStr == null) {
            throw new NullPointerException("str");
        }
        this.m_sStr = sStr;
        this.m_nLength = sStr.length();
    }

    private void _ensureOpen() throws IOException {
        if (this.m_sStr == null) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    @CheckForSigned
    public int read() throws IOException {
        this._ensureOpen();
        if (this.m_nNext >= this.m_nLength) {
            return -1;
        }
        return this.m_sStr.charAt(this.m_nNext++);
    }

    @Override
    @CheckForSigned
    public int read(@Nonnull char[] aBuf, @Nonnegative int nOfs, @Nonnegative int nLen) throws IOException {
        this._ensureOpen();
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aBuf.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aBuf.length);
        }
        if (nLen == 0) {
            return 0;
        }
        if (this.m_nNext >= this.m_nLength) {
            return -1;
        }
        int nChars = Math.min(this.m_nLength - this.m_nNext, nLen);
        this.m_sStr.getChars(this.m_nNext, this.m_nNext + nChars, aBuf, nOfs);
        this.m_nNext += nChars;
        return nChars;
    }

    @Override
    public long skip(long nCharsToSkip) throws IOException {
        this._ensureOpen();
        if (this.m_nNext >= this.m_nLength) {
            return 0L;
        }
        long n = Math.min((long)(this.m_nLength - this.m_nNext), nCharsToSkip);
        n = Math.max((long)(-this.m_nNext), n);
        this.m_nNext = (int)((long)this.m_nNext + n);
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        this._ensureOpen();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int nReadAheadLimit) throws IOException {
        if (nReadAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0: " + nReadAheadLimit);
        }
        this._ensureOpen();
        this.m_nMark = this.m_nNext;
    }

    @Override
    public void reset() throws IOException {
        this._ensureOpen();
        this.m_nNext = this.m_nMark;
    }

    @Override
    public void close() {
        this.m_sStr = null;
    }
}

