/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.impl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.microdom.EMicroNodeType;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.microdom.impl.AbstractMicroNode;
import com.phloc.commons.microdom.impl.MicroDataAware;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroText
extends AbstractMicroNode
implements IMicroText {
    public static final boolean DEFAULT_IGNORABLE_WHITESPACE = false;
    public static final boolean DEFAULT_ESCAPE = true;
    private final MicroDataAware m_aData;
    private final boolean m_bIgnorableWhitespace;
    private boolean m_bEscape = true;

    public MicroText(@Nullable CharSequence sText) {
        this(sText, false);
    }

    public MicroText(@Nullable CharSequence sText, boolean bIgnorableWhitespace) {
        this.m_aData = new MicroDataAware(sText);
        this.m_bIgnorableWhitespace = bIgnorableWhitespace;
    }

    private MicroText(@Nonnull MicroDataAware aData, boolean bIgnorableWhitespace, boolean bEscape) {
        this.m_aData = aData;
        this.m_bIgnorableWhitespace = bIgnorableWhitespace;
        this.m_bEscape = bEscape;
    }

    @Override
    @Nonnull
    public EMicroNodeType getType() {
        return EMicroNodeType.TEXT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getNodeName() {
        return "#text";
    }

    @Override
    @Nonnull
    public String getNodeValue() {
        return this.getData();
    }

    @Override
    @Nonnull
    public String getData() {
        return this.m_aData.getData().toString();
    }

    @Override
    public void appendData(@Nullable CharSequence sData) {
        this.m_aData.appendData(sData);
    }

    @Override
    public void prependData(@Nullable CharSequence sData) {
        this.m_aData.prependData(sData);
    }

    @Override
    public void setData(@Nullable CharSequence sData) {
        this.m_aData.setData(sData);
    }

    @Override
    public boolean isElementContentWhitespace() {
        return this.m_bIgnorableWhitespace;
    }

    @Override
    public boolean isEscape() {
        return this.m_bEscape;
    }

    @Nonnull
    public MicroText setEscape(boolean bEscape) {
        this.m_bEscape = bEscape;
        return this;
    }

    @Override
    @Nonnull
    public IMicroText getClone() {
        return new MicroText(this.m_aData.getClone(), this.m_bIgnorableWhitespace, this.m_bEscape);
    }

    @Override
    public boolean isEqualContent(@Nullable IMicroNode o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MicroText)) {
            return false;
        }
        MicroText rhs = (MicroText)o;
        return this.m_aData.equals(rhs.m_aData) && this.m_bIgnorableWhitespace == rhs.m_bIgnorableWhitespace;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("text", this.getData()).append("ignorableWhitspace", this.m_bIgnorableWhitespace).toString();
    }
}

