/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.name;

import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.name.IHasDisplayText;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.impl.TextFormatter;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class HasDisplayTextWithArgs
implements IHasDisplayText {
    private final IHasDisplayText m_aParentText;
    private final Object[] m_aArgs;

    public HasDisplayTextWithArgs(@Nonnull IHasDisplayText aParentText, Object ... aArgs) {
        if (aParentText == null) {
            throw new NullPointerException("parentText");
        }
        if (ArrayHelper.isEmpty(aArgs)) {
            throw new IllegalArgumentException("arguments may not be empty");
        }
        this.m_aParentText = aParentText;
        this.m_aArgs = aArgs;
    }

    @Override
    @Nullable
    public String getDisplayText(@Nonnull Locale aContentLocale) {
        String sText = this.m_aParentText.getDisplayText(aContentLocale);
        return TextFormatter.getFormattedText(sText, this.m_aArgs);
    }

    public String toString() {
        return new ToStringGenerator(this).append("parentText", this.m_aParentText).append("args", this.m_aArgs).toString();
    }
}

