/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.resource;

import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.system.EJavaVersion;
import com.phloc.commons.text.resource.Utf8ResourceBundle;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ResourceBundleUtils {
    private ResourceBundleUtils() {
    }

    @Nullable
    public static ResourceBundle getResourceBundle(@Nonnull String sBundleName, @Nonnull Locale aContentLocale) {
        return ResourceBundleUtils.getResourceBundle(sBundleName, aContentLocale, ClassHelper.getDefaultClassLoader());
    }

    @Nullable
    public static ResourceBundle getResourceBundle(@Nonnull String sBundleName, @Nonnull Locale aContentLocale, @Nonnull ClassLoader aClassLoader) {
        try {
            return ResourceBundle.getBundle(sBundleName, aContentLocale, aClassLoader);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    @Nullable
    public static ResourceBundle getUtf8ResourceBundle(@Nonnull String sBundleName, @Nonnull Locale aContentLocale) {
        return ResourceBundleUtils.getUtf8ResourceBundle(sBundleName, aContentLocale, ClassHelper.getDefaultClassLoader());
    }

    @Nullable
    public static ResourceBundle getUtf8ResourceBundle(@Nonnull String sBundleName, @Nonnull Locale aContentLocale, @Nonnull ClassLoader aClassLoader) {
        try {
            return Utf8ResourceBundle.getBundle(sBundleName, aContentLocale, aClassLoader);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    @Nullable
    public static String getString(@Nullable ResourceBundle aResourceBundle, @Nonnull @PropertyKey String sKey) {
        if (aResourceBundle != null) {
            try {
                return aResourceBundle.getString(sKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static String getString(@Nonnull String sBundleName, @Nonnull Locale aContentLocale, @Nonnull @PropertyKey String sKey) {
        return ResourceBundleUtils.getString(ResourceBundleUtils.getResourceBundle(sBundleName, aContentLocale), sKey);
    }

    @Nullable
    public static String getString(@Nonnull String sBundleName, @Nonnull Locale aContentLocale, @Nonnull @PropertyKey String sKey, @Nonnull ClassLoader aClassLoader) {
        return ResourceBundleUtils.getString(ResourceBundleUtils.getResourceBundle(sBundleName, aContentLocale, aClassLoader), sKey);
    }

    @Nullable
    public static String getUtf8String(@Nonnull String sBundleName, @Nonnull Locale aContentLocale, @Nonnull @PropertyKey String sKey) {
        return ResourceBundleUtils.getString(ResourceBundleUtils.getUtf8ResourceBundle(sBundleName, aContentLocale), sKey);
    }

    @Nullable
    public static String getUtf8String(@Nonnull String sBundleName, @Nonnull Locale aContentLocale, @Nonnull @PropertyKey String sKey, @Nonnull ClassLoader aClassLoader) {
        return ResourceBundleUtils.getString(ResourceBundleUtils.getUtf8ResourceBundle(sBundleName, aContentLocale, aClassLoader), sKey);
    }

    public static void clearCache() {
        ResourceBundleUtils.clearCache(ClassHelper.getDefaultClassLoader());
    }

    public static void clearCache(@Nonnull ClassLoader aClassLoader) {
        if (EJavaVersion.JDK_16.isSupportedVersion()) {
            try {
                GenericReflection.invokeStaticMethod(ResourceBundle.class, "clearCache", aClassLoader);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

