/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.convert.MicroTypeConverter;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.tree.utils.xml.IConverterTreeXML;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MicroTypeConverterTreeXML<DATATYPE>
implements IConverterTreeXML<DATATYPE> {
    private String m_sNamespaceURI;
    private final String m_sElementName;
    private final Class<? extends DATATYPE> m_aNativeClass;

    public MicroTypeConverterTreeXML(@Nonnull @Nonempty String sElementName, @Nonnull Class<? extends DATATYPE> aNativeClass) {
        this(null, sElementName, aNativeClass);
    }

    public MicroTypeConverterTreeXML(@Nullable String sNamespaceURI, @Nonnull @Nonempty String sElementName, @Nonnull Class<? extends DATATYPE> aNativeClass) {
        if (StringHelper.hasNoText(sElementName)) {
            throw new IllegalArgumentException("elementName");
        }
        if (aNativeClass == null) {
            throw new NullPointerException("nativeClass");
        }
        this.m_sNamespaceURI = sNamespaceURI;
        this.m_sElementName = sElementName;
        this.m_aNativeClass = aNativeClass;
    }

    @Override
    public void appendDataValue(@Nonnull IMicroElement eDataElement, @Nullable DATATYPE aObject) {
        eDataElement.appendChild(MicroTypeConverter.convertToMicroElement(aObject, this.m_sNamespaceURI, this.m_sElementName));
    }

    @Override
    @Nullable
    public DATATYPE getAsDataValue(@Nonnull IMicroElement eDataElement) {
        IMicroElement eChildElement = eDataElement.getFirstChildElement();
        if (eChildElement != null) {
            if (!EqualsUtils.equals(this.m_sNamespaceURI, eChildElement.getNamespaceURI())) {
                throw new IllegalStateException("Namespace mismatch! Expected: " + this.m_sNamespaceURI);
            }
            if (!this.m_sElementName.equals(eChildElement.getTagName())) {
                throw new IllegalStateException("Tag name mismatch! Expected: " + this.m_sElementName);
            }
        }
        return MicroTypeConverter.convertToNative(eChildElement, this.m_aNativeClass);
    }

    @Nonnull
    public static <DATATYPE> MicroTypeConverterTreeXML<DATATYPE> create(@Nonnull @Nonempty String sElementName, @Nonnull Class<? extends DATATYPE> aNativeClass) {
        return new MicroTypeConverterTreeXML<DATATYPE>(sElementName, aNativeClass);
    }

    @Nonnull
    public static <DATATYPE> MicroTypeConverterTreeXML<DATATYPE> create(@Nullable String sNamespaceURI, @Nonnull @Nonempty String sElementName, @Nonnull Class<? extends DATATYPE> aNativeClass) {
        return new MicroTypeConverterTreeXML<DATATYPE>(sNamespaceURI, sElementName, aNativeClass);
    }
}

