/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.namespace;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.iterate.SingleElementIterator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.namespace.AbstractNamespaceContext;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SingleElementNamespaceContext
extends AbstractNamespaceContext {
    private final String m_sPrefix;
    private final String m_sNamespaceURI;

    public SingleElementNamespaceContext(@Nonnull @Nonempty String sNamespaceURI) {
        this("", sNamespaceURI);
    }

    public SingleElementNamespaceContext(@Nonnull String sPrefix, @Nonnull @Nonempty String sNamespaceURI) {
        if (sPrefix == null) {
            throw new NullPointerException("prefix");
        }
        if (StringHelper.hasNoText(sNamespaceURI)) {
            throw new IllegalArgumentException("namespaceURI may not be empty");
        }
        this.m_sPrefix = sPrefix;
        this.m_sNamespaceURI = sNamespaceURI;
    }

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sPrefix.equals("") ? this.m_sNamespaceURI : null;
    }

    @Override
    @Nullable
    protected Iterator<String> getCustomPrefixes(@Nullable String sNamespaceURI) {
        return this.m_sNamespaceURI.equals(sNamespaceURI) ? SingleElementIterator.create(this.m_sPrefix) : null;
    }

    @Override
    @Nullable
    protected String getCustomPrefix(@Nullable String sNamespaceURI) {
        return this.m_sNamespaceURI.equals(sNamespaceURI) ? this.m_sPrefix : null;
    }

    @Override
    @Nullable
    protected String getCustomNamespaceURI(@Nullable String sPrefix) {
        return this.m_sPrefix.equals(sPrefix) ? this.m_sNamespaceURI : null;
    }

    public String toString() {
        return new ToStringGenerator(this).append("prefix", this.m_sPrefix).append("namespaceURI", this.m_sNamespaceURI).toString();
    }
}

