/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import com.phloc.commons.xml.serialize.XMLSerializerPhloc;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Immutable
public final class XMLWriter {
    public static final EXMLVersion DEFAULT_XML_VERSION = EXMLVersion.DEFAULT;
    public static final NamespaceContext DEFAULT_NAMESPACE_CTX = null;
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLWriter.class);
    private static final IStatisticsHandlerSize s_aSizeHdl = StatisticsManager.getSizeHandler(XMLWriter.class);
    private static final XMLWriter s_aInstance = new XMLWriter();

    private XMLWriter() {
    }

    @Nonnull
    public static ESuccess writeToStream(@Nonnull Node aNode, @Nonnull @WillClose OutputStream aOS) {
        return XMLWriter.writeToStream(aNode, aOS, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToStream(@Nonnull Node aNode, @Nonnull @WillClose OutputStream aOS, @Nonnull IXMLWriterSettings aSettings) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (aOS == null) {
            throw new NullPointerException("outputStream");
        }
        if (aSettings == null) {
            throw new NullPointerException("settings");
        }
        try {
            XMLSerializerPhloc aSerializer = new XMLSerializerPhloc(aSettings);
            aSerializer.write(aNode, aOS);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException ex) {
            s_aLogger.error("Error in XML serialization", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            s_aLogger.error("Error in XML serialization", (Throwable)ex);
        }
        finally {
            StreamUtils.close(aOS);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess writeToWriter(@Nonnull Node aNode, @Nonnull @WillClose Writer aWriter) {
        return XMLWriter.writeToWriter(aNode, aWriter, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToWriter(@Nonnull Node aNode, @Nonnull @WillClose Writer aWriter, @Nonnull IXMLWriterSettings aSettings) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (aWriter == null) {
            throw new NullPointerException("writer");
        }
        if (aSettings == null) {
            throw new NullPointerException("settings");
        }
        try {
            XMLSerializerPhloc aSerializer = new XMLSerializerPhloc(aSettings);
            aSerializer.write(aNode, aWriter);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException ex) {
            s_aLogger.error("Error in XML serialization", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            s_aLogger.error("Error in XML serialization", (Throwable)ex);
        }
        finally {
            StreamUtils.close(aWriter);
        }
        return ESuccess.FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getNodeAsString(@Nonnull Node aNode, @Nonnull IXMLWriterSettings aSettings) {
        NonBlockingStringWriter aWriter;
        block4: {
            String string;
            aWriter = null;
            try {
                aWriter = new NonBlockingStringWriter(51200);
                if (!XMLWriter.writeToWriter(aNode, aWriter, aSettings).isSuccess()) break block4;
                s_aSizeHdl.addSize(aWriter.size());
                string = aWriter.getAsString();
            }
            catch (Throwable t) {
                try {
                    s_aLogger.error("Error serializing DOM node with settings " + aSettings.toString(), t);
                }
                catch (Throwable throwable) {
                    StreamUtils.close(aWriter);
                    throw throwable;
                }
                StreamUtils.close(aWriter);
            }
            StreamUtils.close(aWriter);
            return string;
        }
        StreamUtils.close(aWriter);
        return null;
    }

    @Nullable
    public static String getXMLString(@Nonnull Node aNode) {
        return XMLWriter.getNodeAsString(aNode, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

