/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.hash;

import com.phloc.commons.hash.HashCodeCalculator;
import com.phloc.commons.hash.IHashCodeGenerator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Node;

@NotThreadSafe
public final class HashCodeGenerator
implements IHashCodeGenerator {
    public static final int INITIAL_HASHCODE = 17;
    private boolean m_bClosed = false;
    private int m_nHC = 17;

    public HashCodeGenerator(@Nonnull Object aSrcObject) {
        this(aSrcObject instanceof Class ? (Class<?>)aSrcObject : aSrcObject.getClass());
    }

    public HashCodeGenerator(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        this.append(aClass.getName());
        Class<?> aComponentType = aClass.getComponentType();
        if (aComponentType != null) {
            this.append(aComponentType.getName());
        }
    }

    private HashCodeGenerator(int nSuperHashCode) {
        this.m_nHC = nSuperHashCode;
    }

    private void _checkClosed() {
        if (this.m_bClosed) {
            throw new IllegalStateException("Hash code cannot be changed anymore!");
        }
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(boolean x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(byte x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(char x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(double x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(float x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(int x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(long x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(short x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Object x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Enum<?> x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable boolean[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable byte[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable char[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable double[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable float[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable int[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable long[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable short[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Object[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Enum<?>[] x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Nonnull
    public HashCodeGenerator append(@Nullable StringBuffer x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Nonnull
    public HashCodeGenerator append(@Nullable StringBuilder x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Iterable<?> x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Map<?, ?> x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    @Nonnull
    public HashCodeGenerator append(@Nullable Node x) {
        this._checkClosed();
        this.m_nHC = HashCodeCalculator.append(this.m_nHC, x);
        return this;
    }

    @Override
    public int getHashCode() {
        this.m_bClosed = true;
        if (this.m_nHC == 0) {
            this.m_nHC = -1;
        }
        return this.m_nHC;
    }

    @Nonnull
    public Integer getHashCodeObj() {
        return this.getHashCode();
    }

    @Nonnull
    public static HashCodeGenerator getDerived(int nSuperHashCode) {
        if (nSuperHashCode == 0) {
            throw new IllegalArgumentException("Passed hash code is invalid!");
        }
        return new HashCodeGenerator(nSuperHashCode);
    }
}

