/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.CGlobal;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.string.StringHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SimpleFileIO {
    private static final SimpleFileIO s_aInstance = new SimpleFileIO();

    private SimpleFileIO() {
    }

    @Nullable
    public static byte[] readFileBytes(@Nullable File aFile) {
        return aFile == null ? null : StreamUtils.getAllBytes(FileUtils.getInputStream(aFile));
    }

    @Nullable
    public static String readFileAsString(@Nullable File aFile, @Nonnull String sCharset) {
        return aFile == null ? null : StreamUtils.getAllBytesAsString((InputStream)FileUtils.getInputStream(aFile), sCharset);
    }

    @Nullable
    public static String readFileAsString(@Nullable File aFile, @Nonnull Charset aCharset) {
        return aFile == null ? null : StreamUtils.getAllBytesAsString((InputStream)FileUtils.getInputStream(aFile), aCharset);
    }

    @Nullable
    public static List<String> readFileLines(@Nullable File aFile, @Nonnull String sCharset) {
        return aFile == null ? null : StreamUtils.readStreamLines((InputStream)FileUtils.getInputStream(aFile), sCharset);
    }

    @Nullable
    public static List<String> readFileLines(@Nullable File aFile, @Nonnull Charset aCharset) {
        return aFile == null ? null : StreamUtils.readStreamLines((InputStream)FileUtils.getInputStream(aFile), aCharset);
    }

    public static void readFileLines(@Nullable File aFile, @Nonnull String sCharset, @Nonnull List<String> aTargetList) {
        if (aFile != null) {
            StreamUtils.readStreamLines((InputStream)FileUtils.getInputStream(aFile), sCharset, aTargetList);
        }
    }

    public static void readFileLines(@Nullable File aFile, @Nonnull Charset aCharset, @Nonnull List<String> aTargetList) {
        if (aFile != null) {
            StreamUtils.readStreamLines((InputStream)FileUtils.getInputStream(aFile), aCharset, aTargetList);
        }
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File aFile, @Nonnull byte[] aContent) {
        FileOutputStream aFOS = FileUtils.getOutputStream(aFile);
        return aFOS == null ? ESuccess.FAILURE : StreamUtils.writeStream(aFOS, aContent);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File aFile, @Nonnull byte[] aContent, @Nonnegative int nOffset, @Nonnegative int nLength) {
        FileOutputStream aFOS = FileUtils.getOutputStream(aFile);
        return aFOS == null ? ESuccess.FAILURE : StreamUtils.writeStream(aFOS, aContent, nOffset, nLength);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File aFile, @Nonnull String sContent, @Nonnull String sCharset) {
        FileOutputStream aFOS = FileUtils.getOutputStream(aFile);
        return aFOS == null ? ESuccess.FAILURE : StreamUtils.writeStream((OutputStream)aFOS, sContent, sCharset);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File aFile, @Nonnull String sContent, @Nonnull Charset aCharset) {
        FileOutputStream aFOS = FileUtils.getOutputStream(aFile);
        return aFOS == null ? ESuccess.FAILURE : StreamUtils.writeStream((OutputStream)aFOS, sContent, aCharset);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File aFile, @Nonnull List<String> aContent, @Nonnull String sCharset) {
        return SimpleFileIO.writeFile(aFile, StringHelper.getImploded(CGlobal.LINE_SEPARATOR, aContent), sCharset);
    }

    @Nonnull
    public static ESuccess writeFile(@Nonnull File aFile, @Nonnull List<String> aContent, @Nonnull Charset aCharset) {
        return SimpleFileIO.writeFile(aFile, StringHelper.getImploded(CGlobal.LINE_SEPARATOR, aContent), aCharset);
    }
}

