/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.SystemProperties;
import com.phloc.commons.string.StringParser;
import javax.annotation.Nonnull;

public enum EProcessorArchitecture {
    UNKNOWN(-1),
    ARCH_32(32),
    ARCH_64(64);

    private static final String SUN_SYSTEM_PROPERTY = "sun.arch.data.model";
    private static volatile EProcessorArchitecture s_aInstance;
    private final int m_nBits;

    private EProcessorArchitecture(int nBits) {
        if (nBits > 0 && nBits % 8 != 0) {
            throw new IllegalArgumentException("Passed bit count is illegal: " + nBits);
        }
        this.m_nBits = nBits;
    }

    public int getBits() {
        return this.m_nBits;
    }

    public int getBytes() {
        return this.m_nBits == -1 ? this.m_nBits : this.m_nBits / 8;
    }

    public static int getCurrentArchitectureBits() {
        return StringParser.parseInt(SystemProperties.getPropertyValue(SUN_SYSTEM_PROPERTY), -1);
    }

    @Nonnull
    public static EProcessorArchitecture forBits(int nBits) {
        for (EProcessorArchitecture eArch : EProcessorArchitecture.values()) {
            if (nBits != eArch.getBits()) continue;
            return eArch;
        }
        return UNKNOWN;
    }

    @Nonnull
    static EProcessorArchitecture getCurrentArchitecture() {
        EProcessorArchitecture ret = s_aInstance;
        if (ret == null) {
            s_aInstance = ret = EProcessorArchitecture.forBits(EProcessorArchitecture.getCurrentArchitectureBits());
        }
        return ret;
    }

    static {
        s_aInstance = null;
    }
}

