/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriteable;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSSelectorMember;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CSSSelector
implements ICSSWriteable {
    private final List<ICSSSelectorMember> m_aMembers = new ArrayList<ICSSSelectorMember>();

    public void addMember(@Nonnull ICSSSelectorMember aMember) {
        if (aMember == null) {
            throw new NullPointerException("member");
        }
        this.m_aMembers.add(aMember);
    }

    @Nonnull
    public EChange removeMember(@Nonnull ICSSSelectorMember aMember) {
        return EChange.valueOf((boolean)this.m_aMembers.remove(aMember));
    }

    @Nonnull
    public EChange removeMember(@Nonnegative int nMemberIndex) {
        if (nMemberIndex < 0 || nMemberIndex >= this.m_aMembers.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMembers.remove(nMemberIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSSelectorMember> getAllMembers() {
        return ContainerHelper.newList(this.m_aMembers);
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        StringBuilder aSB = new StringBuilder();
        for (ICSSSelectorMember aMember : this.m_aMembers) {
            aSB.append(aMember.getAsCSSString(aSettings, nIndentLevel));
        }
        return aSB.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSSelector)) {
            return false;
        }
        CSSSelector rhs = (CSSSelector)o;
        return ((Object)this.m_aMembers).equals(rhs.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).toString();
    }
}

