/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.Axis;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.ExceptPattern;
import net.sf.saxon.pattern.IntersectPattern;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.LocationPathPattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.IntegerValue;

public class PatternMaker {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Pattern fromExpression(Expression expression, Configuration config, boolean is30) throws XPathException {
        void var3_24;
        block43: {
            block45: {
                int kind;
                NodeTest test;
                byte axis;
                block47: {
                    block46: {
                        block44: {
                            Object var3_3 = null;
                            if (expression instanceof DocumentSorter) {
                                expression = ((DocumentSorter)expression).getBaseExpression();
                            }
                            if (!(expression instanceof VennExpression)) break block44;
                            int op = ((VennExpression)expression).getOperator();
                            if (op == 1) {
                                UnionPattern unionPattern = new UnionPattern(PatternMaker.fromExpression(((VennExpression)expression).getOperands()[0], config, is30), PatternMaker.fromExpression(((VennExpression)expression).getOperands()[1], config, is30));
                                break block43;
                            } else {
                                if (!is30) {
                                    throw new XPathException("Cannot use intersect or except in an XSLT 2.0 pattern");
                                }
                                if (op == 24) {
                                    ExceptPattern exceptPattern = new ExceptPattern(PatternMaker.fromExpression(((VennExpression)expression).getOperands()[0], config, is30), PatternMaker.fromExpression(((VennExpression)expression).getOperands()[1], config, is30));
                                    break block43;
                                } else {
                                    IntersectPattern intersectPattern = new IntersectPattern(PatternMaker.fromExpression(((VennExpression)expression).getOperands()[0], config, is30), PatternMaker.fromExpression(((VennExpression)expression).getOperands()[1], config, is30));
                                }
                            }
                            break block43;
                        }
                        if (!(expression instanceof AxisExpression)) break block45;
                        axis = ((AxisExpression)expression).getAxis();
                        test = ((AxisExpression)expression).getNodeTest();
                        if (test == null) {
                            test = AnyNodeTest.getInstance();
                        }
                        if (test instanceof AnyNodeTest && (axis == 3 || axis == 4)) {
                            test = AnyChildNodeTest.getInstance();
                        }
                        kind = test.getPrimitiveType();
                        if (axis != 12 || kind != 9) break block46;
                        ItemTypePattern itemTypePattern = new ItemTypePattern(test);
                        break block43;
                    }
                    if (axis != 2) break block47;
                    if (kind == 0) {
                        ItemTypePattern itemTypePattern = new ItemTypePattern(NodeKindTest.ATTRIBUTE);
                        break block43;
                    } else if (!Axis.containsNodeKind(axis, kind)) {
                        ItemTypePattern itemTypePattern = new ItemTypePattern(EmptySequenceTest.getInstance());
                        break block43;
                    } else {
                        ItemTypePattern itemTypePattern = new ItemTypePattern(test);
                    }
                    break block43;
                }
                if (axis != 3 && axis != 4 && axis != 5) {
                    throw new XPathException("Only downwards axes are allowed in a pattern", "XTSE0340");
                }
                if (kind != 0 && !Axis.containsNodeKind(axis, kind)) {
                    test = EmptySequenceTest.getInstance();
                }
                ItemTypePattern itemTypePattern = new ItemTypePattern(test);
                break block43;
            }
            if (expression instanceof FilterExpression) {
                Expression base = ((FilterExpression)expression).getControllingExpression();
                Expression filter = ((FilterExpression)expression).getFilter();
                Pattern basePattern = PatternMaker.fromExpression(base, config, is30);
                if (basePattern instanceof ItemTypePattern) {
                    LocationPathPattern path = new LocationPathPattern();
                    path.setNodeTest((NodeTest)basePattern.getItemType());
                    basePattern = path;
                }
                if (basePattern instanceof LocationPathPattern) {
                    ((LocationPathPattern)basePattern).addFilter(filter);
                    Pattern pattern = basePattern;
                } else {
                    if (!is30) {
                        throw new XPathException("The filtered expression in an XSLT 2.0 pattern must be a simple step");
                    }
                    PatternWithPredicate patternWithPredicate = new PatternWithPredicate(basePattern, filter);
                }
            } else {
                if (expression instanceof FirstItemExpression) {
                    Pattern basePattern = PatternMaker.fromExpression(((FirstItemExpression)expression).getBaseExpression(), config, is30);
                    if (basePattern instanceof ItemTypePattern) {
                        LocationPathPattern path = new LocationPathPattern();
                        path.setNodeTest((NodeTest)basePattern.getItemType());
                        basePattern = path;
                    }
                    if (basePattern instanceof LocationPathPattern) {
                        ((LocationPathPattern)basePattern).addFilter(new Literal(IntegerValue.PLUS_ONE));
                        Pattern pattern = basePattern;
                        break block43;
                    } else {
                        if (is30) {
                            return basePattern;
                        }
                        throw new XPathException("The filtered expression in an XSLT 2.0 pattern must be a simple step");
                    }
                }
                if (expression instanceof SlashExpression) {
                    AxisExpression mid;
                    SlashExpression start;
                    Expression head = ((SlashExpression)expression).getLeadingSteps();
                    Expression tail = ((SlashExpression)expression).getLastStep();
                    Pattern tailPattern = PatternMaker.fromExpression(tail, config, is30);
                    if (tailPattern instanceof ItemTypePattern) {
                        if (tailPattern.getItemType() instanceof EmptySequenceTest) {
                            return tailPattern;
                        }
                        LocationPathPattern path = new LocationPathPattern();
                        path.setNodeTest((NodeTest)tailPattern.getItemType());
                        tailPattern = path;
                    }
                    if (!(tailPattern instanceof LocationPathPattern)) {
                        throw new XPathException("The path in a pattern must contain simple steps: found " + tailPattern.toString());
                    }
                    if (((LocationPathPattern)tailPattern).getUpperPattern() != null) {
                        throw new XPathException("The path in a pattern must contain simple steps");
                    }
                    byte axis = 9;
                    Pattern headPattern = null;
                    if (head instanceof SlashExpression && (start = (SlashExpression)head).getControlledExpression() instanceof AxisExpression && (mid = (AxisExpression)start.getControlledExpression()).getAxis() == 5 && mid.getNodeTest() instanceof AnyNodeTest) {
                        axis = 0;
                        headPattern = PatternMaker.fromExpression(start.getControllingExpression(), config, is30);
                    }
                    if (headPattern == null) {
                        axis = PatternMaker.getAxisForPathStep(tail);
                        headPattern = PatternMaker.fromExpression(head, config, is30);
                    }
                    ((LocationPathPattern)tailPattern).setUpperPattern(axis, headPattern);
                    Pattern pattern = tailPattern;
                } else if (expression instanceof ContextItemExpression) {
                    AnchorPattern anchorPattern = new AnchorPattern();
                } else if (expression instanceof RootExpression) {
                    ItemTypePattern itemTypePattern = new ItemTypePattern(NodeKindTest.DOCUMENT);
                } else if (Literal.isEmptySequence(expression)) {
                    ItemTypePattern itemTypePattern = new ItemTypePattern(EmptySequenceTest.getInstance());
                } else if (expression instanceof PatternSponsor) {
                    Pattern pattern = ((PatternSponsor)expression).getPattern();
                } else {
                    TypeHierarchy th = config.getTypeHierarchy();
                    ItemType type = expression.getItemType(th);
                    if ((expression.getDependencies() & 0xE) == 0 && (type instanceof NodeTest || expression instanceof VariableReference)) {
                        NodeSetPattern nodeSetPattern = new NodeSetPattern(expression, config);
                    }
                }
            }
        }
        if (var3_24 == null) {
            throw new XPathException("Cannot convert the expression {" + expression.toString() + "} to a pattern");
        }
        var3_24.setOriginalText(expression.toString());
        var3_24.setSystemId(expression.getSystemId());
        var3_24.setLineNumber(expression.getLineNumber());
        var3_24.setExecutable(expression.getExecutable());
        return var3_24;
    }

    public static byte getAxisForPathStep(Expression step) throws XPathException {
        if (step instanceof AxisExpression) {
            return Axis.inverseAxis[((AxisExpression)step).getAxis()];
        }
        if (step instanceof FilterExpression) {
            return PatternMaker.getAxisForPathStep(((FilterExpression)step).getControllingExpression());
        }
        if (step instanceof FirstItemExpression) {
            return PatternMaker.getAxisForPathStep(((FirstItemExpression)step).getBaseExpression());
        }
        if (step instanceof SlashExpression) {
            return PatternMaker.getAxisForPathStep(((SlashExpression)step).getFirstStep());
        }
        if (step instanceof ContextItemExpression) {
            return 12;
        }
        throw new XPathException("The path in a pattern must contain simple steps");
    }
}

