/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.LastOwnerException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.jigsaw.acl.AuthUserPrincipal;
import org.w3c.jigsaw.acl.HTTPPrincipal;
import org.w3c.jigsaw.acl.JAcl;
import org.w3c.jigsaw.auth.AuthRealm;
import org.w3c.jigsaw.auth.AuthUser;
import org.w3c.jigsaw.auth.IPMatcher;
import org.w3c.jigsaw.auth.RealmsCatalog;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.tools.resources.StringAttribute;

public class AclRealm
extends JAcl {
    protected static int ATTR_REALM = -1;
    protected static int ATTR_ALLOWED_USERS = -1;
    protected static int ATTR_METHODS = -1;
    protected IPMatcher ipmatcher = null;
    protected RealmsCatalog catalog = null;
    protected ResourceReference rr_realm = null;
    protected String loaded_realm = null;
    protected Vector entries = null;

    public String[] getMethods() {
        return (String[])this.getValue(ATTR_METHODS, null);
    }

    public String getRealm() {
        return (String)this.getValue(ATTR_REALM, null);
    }

    public String[] getAllowedUsers() {
        return (String[])this.getValue(ATTR_ALLOWED_USERS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void acquireRealm() {
        Object object;
        this.entries = new Vector(10);
        if (this.catalog == null) {
            object = (httpd)((FramedResource)this.getTargetResource()).getServer();
            this.catalog = ((httpd)object).getRealmsCatalog();
        }
        if ((object = this.getRealm()) == null) {
            return;
        }
        if (this.rr_realm != null && ((String)object).equals(this.loaded_realm)) {
            return;
        }
        this.rr_realm = this.catalog.loadRealm((String)object);
        if (this.rr_realm != null) {
            try {
                AuthRealm authRealm = (AuthRealm)this.rr_realm.lock();
                Enumeration enumeration = authRealm.enumerateUserNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    ResourceReference resourceReference = authRealm.loadUser(string);
                    try {
                        AuthUser authUser = (AuthUser)resourceReference.lock();
                        this.createEntry(authUser);
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        System.out.println("Invalid user reference : " + string);
                    }
                    finally {
                        resourceReference.unlock();
                    }
                }
            }
            catch (InvalidResourceException invalidResourceException) {
            }
            finally {
                this.rr_realm.unlock();
            }
        }
    }

    protected boolean checkUser(AuthUser authUser) {
        String[] stringArray = this.getAllowedUsers();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(authUser.getName())) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    protected void createEntry(AuthUser authUser) {
        if (this.checkUser(authUser)) {
            this.entries.addElement(new AuthUserPrincipal(authUser, this.getName()));
        }
    }

    protected boolean hasPrincipal(Principal principal) {
        int n = this.entries.indexOf(principal);
        return n != -1;
    }

    public boolean addOwner(Principal principal, Principal principal2) throws NotOwnerException {
        throw new NotOwnerException();
    }

    public boolean deleteOwner(Principal principal, Principal principal2) throws NotOwnerException, LastOwnerException {
        throw new NotOwnerException();
    }

    public boolean isOwner(Principal principal) {
        return false;
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        throw new NotOwnerException();
    }

    public String getName() {
        return this.getRealm();
    }

    public boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        throw new NotOwnerException();
    }

    public boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        throw new NotOwnerException();
    }

    public Enumeration getPermissions(Principal principal) {
        return null;
    }

    public Enumeration entries() {
        return null;
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        String string;
        int n;
        this.acquireRealm();
        String[] stringArray = this.getMethods();
        boolean bl = false;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!permission.equals(stringArray[n])) continue;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return true;
        }
        n = this.hasPrincipal(principal) ? 1 : 0;
        if (n != 0 && (string = principal.getName()) != null) {
            try {
                HTTPPrincipal hTTPPrincipal = (HTTPPrincipal)principal;
                Request request = hTTPPrincipal.getRequest();
                if (string != null) {
                    request.setState("org.w3c.jigsaw.auth.AuthFilter.user", string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n != 0;
    }

    public String toString() {
        return this.getName();
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
    }

    static {
        Attribute attribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.acl.AclRealm");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        attribute = new StringAttribute("realm", null, 6);
        ATTR_REALM = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("users", null, 2);
        ATTR_ALLOWED_USERS = AttributeRegistry.registerAttribute(clazz, attribute);
        attribute = new StringArrayAttribute("methods", null, 2);
        ATTR_METHODS = AttributeRegistry.registerAttribute(clazz, attribute);
    }
}

