/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;

public class AccessLimitFilter
extends ResourceFilter {
    protected static int ATTR_LIMIT = -1;
    protected static int ATTR_TIMEOUT = -1;
    protected int count = 0;

    public int getLimit() {
        return this.getInt(ATTR_LIMIT, 1);
    }

    public int getTimeout() {
        return this.getInt(ATTR_TIMEOUT, -1);
    }

    public synchronized ReplyInterface ingoingFilter(RequestInterface requestInterface) throws HTTPException {
        Request request = (Request)requestInterface;
        int n = this.getLimit();
        int n2 = this.getTimeout();
        if (n < 0) {
            return null;
        }
        while (this.count >= n) {
            if (n2 > 0) {
                try {
                    this.wait(n2, 0);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.count < n) continue;
                String string = "Simultaneous number of access to this page is limited to " + n + " you was not able to " + "get in.";
                Reply reply = request.makeReply(503);
                reply.setContent(string);
                throw new HTTPException(reply);
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.count;
        return null;
    }

    public synchronized ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) {
        --this.count;
        this.notifyAll();
        return null;
    }

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.AccessLimitFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("limit", new Integer(1), 2);
        ATTR_LIMIT = AttributeRegistry.registerAttribute(clazz, integerAttribute);
        integerAttribute = new IntegerAttribute("timeout", new Integer(60000), 2);
        ATTR_TIMEOUT = AttributeRegistry.registerAttribute(clazz, integerAttribute);
    }
}

