/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.w3c.jigsaw.http.ClientFactory;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.http.socket.SocketClient;
import org.w3c.jigsaw.http.socket.SocketClientState;
import org.w3c.jigsaw.http.socket.SocketConnectionProp;
import org.w3c.util.LRUList;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.Status;
import org.w3c.util.SyncLRUList;
import org.w3c.util.ThreadCache;

public class SocketClientFactory
implements ClientFactory,
PropertyMonitoring,
Status {
    private static final boolean debug = false;
    private static final boolean debugstats = false;
    private static final boolean debugthread = false;
    public static final int MINSPARE_FREE = 5;
    public static final int MAXSPARE_FREE = 10;
    public static final int MAXSPARE_IDLE = 20;
    public static final int MAXTHREADS = 40;
    public static final int MAXCLIENTS = 32;
    public static final int IDLETO = 10000;
    public static final int AVG_LIGHT = 1;
    public static final int AVG_NORMAL = 2;
    public static final int AVG_HIGH = 3;
    public static final int AVG_DEAD = 4;
    public static final String MINSPARE_FREE_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.minFree";
    public static final String MAXSPARE_FREE_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.maxFree";
    public static final String MAXSPARE_IDLE_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.maxIdle";
    public static final String MAXTHREADS_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.maxThreads";
    public static final String MAXCLIENTS_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.maxClients";
    public static final String IDLETO_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.idleTimeout";
    public static final String BINDADDR_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.bindAddress";
    public static final String TIMEOUT_P = "org.w3c.jigsaw.http.socket.SocketClientFactory.timeout";
    int minFree = 0;
    int maxFree = 0;
    int maxIdle = 0;
    int maxClients = 0;
    InetAddress bindAddr = null;
    int timeout = 0;
    int count = 0;
    httpd server = null;
    ObservableProperties props = null;
    int busyCount = 0;
    LRUList idleList = null;
    LRUList freeList = null;
    SocketClientState csList = null;
    int idleCount = 0;
    int freeCount = 0;
    int clientCount = 0;
    int clientEstim = 0;
    ThreadCache threadcache = null;
    int loadavg = 1;
    boolean alive = true;

    public String getHTMLStatus() {
        int n;
        int n2;
        InetAddress inetAddress;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        SocketClientState socketClientState = null;
        Object var10_8 = null;
        socketClientState = this.csList;
        while (socketClientState != null) {
            if (socketClientState.status == 1) {
                inetAddress = socketClientState.client.getInetAddress();
                n2 = socketClientState.client.getBindCount();
                n = socketClientState.client.getRequestCount();
                ++n5;
                n6 += n2;
                n7 += n;
            }
            socketClientState = socketClientState.csnext;
        }
        socketClientState = (SocketClientState)this.idleList.getHead();
        while (socketClientState != null) {
            inetAddress = socketClientState.client.getInetAddress();
            ++n3;
            n2 = socketClientState.client.getBindCount();
            n = socketClientState.client.getRequestCount();
            n6 += n2;
            n7 += n;
            socketClientState = (SocketClientState)this.idleList.getNext(socketClientState);
        }
        socketClientState = (SocketClientState)this.freeList.getHead();
        while (socketClientState != null) {
            ++n4;
            n2 = socketClientState.client.getBindCount();
            n = socketClientState.client.getRequestCount();
            n6 += n2;
            n7 += n;
            socketClientState = (SocketClientState)this.freeList.getNext(socketClientState);
        }
        stringBuffer.append("<table border class=\"thread\">\n<caption>Thread counts</caption><tr><th>free<th>idle<th>used<th>estim<th>total<th>Load</tr>");
        stringBuffer.append("<tr><td>");
        stringBuffer.append(this.freeCount);
        stringBuffer.append('(');
        stringBuffer.append(n4);
        stringBuffer.append(")</td><td>");
        stringBuffer.append(this.idleCount);
        stringBuffer.append('(');
        stringBuffer.append(n3);
        stringBuffer.append(")</td><td>");
        stringBuffer.append(this.clientCount - this.freeCount - this.idleCount);
        stringBuffer.append('(');
        stringBuffer.append(n5);
        stringBuffer.append(")</td><td>");
        stringBuffer.append(this.clientEstim);
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.clientCount);
        stringBuffer.append("</td><td>");
        stringBuffer.append(this.loadavg);
        stringBuffer.append("</td></tr></table>\n");
        stringBuffer.append("<table border class=\"usage\">\n<caption>Usage</caption><tr><th>ReqCount<th>BindCount<th>Diff</tr>\n<tr><td>");
        stringBuffer.append(n7);
        stringBuffer.append("</td><td>");
        stringBuffer.append(n6);
        stringBuffer.append("</td><td>");
        stringBuffer.append(n7 - n6);
        stringBuffer.append("</td></tr></table>\n");
        return stringBuffer.toString();
    }

    public boolean propertyChanged(String string) {
        httpd httpd2 = this.server;
        if (string.equals(MINSPARE_FREE_P)) {
            this.minFree = this.props.getInteger(MINSPARE_FREE_P, this.minFree);
        } else if (string.equals(MAXSPARE_FREE_P)) {
            this.maxFree = this.props.getInteger(MAXSPARE_FREE_P, this.maxFree);
        } else if (string.equals(MAXSPARE_IDLE_P)) {
            this.maxIdle = this.props.getInteger(MAXSPARE_IDLE_P, this.maxIdle);
        } else if (string.equals(MAXTHREADS_P)) {
            int n = this.props.getInteger(MAXTHREADS_P, -1);
            if (n > 0) {
                this.threadcache.setCachesize(n);
            }
        } else if (string.equals(IDLETO_P)) {
            int n = this.props.getInteger(IDLETO_P, -1);
            if (n > 0) {
                this.threadcache.setIdleTimeout(n);
            }
        } else if (string.equals(MAXCLIENTS_P)) {
            int n = this.props.getInteger(MAXCLIENTS_P, -1);
            if (n > this.maxClients) {
                int n2 = this.maxClients - n;
                while (--n2 >= 0) {
                    this.addClient(true);
                }
            } else if (n > 0) {
                this.maxClients = n;
            }
        } else if (string.equals(BINDADDR_P)) {
            try {
                this.bindAddr = InetAddress.getByName(this.props.getString(BINDADDR_P, null));
            }
            catch (Exception exception) {}
        } else if (string.equals(TIMEOUT_P)) {
            this.timeout = this.props.getInteger(IDLETO_P, this.timeout);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deleteClient(SocketClientState socketClientState) {
        SocketClientState socketClientState2 = this.csList;
        synchronized (socketClientState2) {
            if (socketClientState.csprev == null) {
                this.csList = socketClientState.csnext;
            } else if (socketClientState.csnext == null) {
                socketClientState.csprev.csnext = null;
            } else {
                socketClientState.csprev.csnext = socketClientState.csnext;
                socketClientState.csnext.csprev = socketClientState.csprev;
            }
        }
    }

    protected SocketClient createClient(httpd httpd2, SocketClientState socketClientState) {
        return new SocketClient(httpd2, this, socketClientState);
    }

    protected synchronized SocketClientState addClient(boolean bl) {
        SocketClient socketClient;
        SocketClientState socketClientState = this.csList = new SocketClientState(this.csList);
        socketClientState.client = socketClient = this.createClient(this.server, socketClientState);
        ++this.clientCount;
        ++this.clientEstim;
        if (bl) {
            socketClientState.status = 2;
            this.freeList.toHead(socketClientState);
            ++this.freeCount;
        }
        return socketClientState;
    }

    private final void checkDeadClients() {
        SocketClientState socketClientState = null;
        socketClientState = this.csList;
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (socketClientState != null) {
            if (socketClientState.client != null) {
                ++n3;
                switch (socketClientState.status) {
                    case 1: {
                        if (socketClientState.client.thread != null) break;
                        if (socketClientState.marked) {
                            if (this.clientEstim <= this.maxClients) {
                                socketClientState.marked = false;
                                ++this.freeCount;
                                this.updateLoadAverage();
                                this.freeList.toHead(socketClientState);
                                socketClientState.status = 2;
                                socketClientState.client.done = true;
                            }
                            bl = false;
                            break;
                        }
                        socketClientState.marked = true;
                        break;
                    }
                    case 2: {
                        ++n2;
                        socketClientState.marked = false;
                        break;
                    }
                    default: {
                        socketClientState.marked = false;
                    }
                }
            }
            socketClientState = socketClientState.csnext;
        }
        if (n2 != this.freeCount) {
            socketClientState = (SocketClientState)this.idleList.getHead();
            while (socketClientState != null) {
                ++n;
                socketClientState = (SocketClientState)this.idleList.getNext(socketClientState);
            }
            socketClientState = (SocketClientState)this.freeList.getHead();
            n2 = 0;
            while (socketClientState != null) {
                ++n2;
                socketClientState = (SocketClientState)this.freeList.getNext(socketClientState);
            }
            this.freeCount = n2;
            this.idleCount = n;
        }
    }

    private final void updateLoadAverage() {
        int n = this.loadavg;
        if (this.freeCount >= this.maxFree) {
            this.loadavg = 1;
        } else if (this.freeCount >= this.minFree || this.idleCount >= this.maxIdle) {
            this.loadavg = 2;
            if (2 < n) {
                this.server.thread.setPriority(10);
            }
        } else if (this.freeCount > 0) {
            this.loadavg = 3;
            if (3 > n) {
                this.server.thread.setPriority(this.server.getClientThreadPriority() - 2);
            }
        } else {
            this.loadavg = 4;
        }
    }

    private final synchronized void incrClientCount() {
        ++this.clientCount;
        ++this.clientEstim;
        this.updateLoadAverage();
    }

    private final synchronized void decrClientCount() {
        --this.clientCount;
        this.updateLoadAverage();
    }

    private final synchronized boolean incrFreeCount() {
        if (this.clientEstim > this.maxClients) {
            --this.clientEstim;
            return false;
        }
        ++this.freeCount;
        this.updateLoadAverage();
        return true;
    }

    private final synchronized boolean decrFreeCount() {
        if (this.freeCount > 0) {
            --this.freeCount;
            this.updateLoadAverage();
            return true;
        }
        return false;
    }

    private final synchronized boolean incrIdleCount() {
        if (this.loadavg > 3 || this.idleCount + 1 >= this.maxIdle) {
            return false;
        }
        ++this.idleCount;
        this.updateLoadAverage();
        return true;
    }

    private final synchronized boolean decrIdleCount() {
        if (this.idleCount > 0) {
            --this.idleCount;
            this.updateLoadAverage();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean idleClientRemove(SocketClient socketClient) {
        if (!this.alive) {
            return false;
        }
        SocketClientState socketClientState = socketClient.state;
        SocketClientState socketClientState2 = this.csList;
        synchronized (socketClientState2) {
            switch (socketClientState.status) {
                case 0: {
                    this.decrIdleCount();
                    this.idleList.remove(socketClientState);
                    socketClientState.status = 2;
                    break;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean clientConnectionFinished(SocketClient socketClient) {
        if (!this.alive) {
            return false;
        }
        SocketClientState socketClientState = socketClient.state;
        SocketClientState socketClientState2 = this.csList;
        synchronized (socketClientState2) {
            switch (socketClientState.status) {
                case 0: {
                    this.decrIdleCount();
                    this.idleList.remove(socketClientState);
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    if (!socketClient.done) break;
                    socketClient.done = false;
                    return true;
                }
            }
            if (this.incrFreeCount()) {
                socketClientState.status = 2;
                this.freeList.toHead(socketClientState);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientFinished(SocketClient socketClient) {
        if (!this.alive) {
            return;
        }
        SocketClientState socketClientState = socketClient.state;
        SocketClientState socketClientState2 = this.csList;
        synchronized (socketClientState2) {
            switch (socketClientState.status) {
                case 0: {
                    break;
                }
                case 2: {
                    this.decrFreeCount();
                    this.freeList.remove(socketClientState);
                    break;
                }
                default: {
                    String string = socketClient + ": finished with unknown status " + socketClientState.status;
                    this.server.errlog(string);
                }
            }
            socketClientState.status = 4;
            this.decrClientCount();
            this.deleteClient(socketClientState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyUse(SocketClient socketClient) {
        SocketClientState socketClientState = socketClient.state;
        SocketClientState socketClientState2 = this.csList;
        synchronized (socketClientState2) {
            if (socketClientState.status == 0) {
                this.decrIdleCount();
                this.idleList.remove(socketClientState);
            }
            socketClientState.status = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyIdle(SocketClient socketClient) {
        SocketClientState socketClientState = socketClient.state;
        if (this.alive) {
            SocketClientState socketClientState2 = this.csList;
            synchronized (socketClientState2) {
                if (this.incrIdleCount()) {
                    socketClientState.status = 0;
                    this.idleList.toHead(socketClientState);
                    return true;
                }
                int n = Math.max(this.maxFree - this.freeCount, this.maxIdle - this.idleCount);
                this.killSomeClients(n > 0 ? n : 1);
                if (this.incrIdleCount()) {
                    socketClientState.status = 0;
                    this.idleList.toHead(socketClientState);
                    return true;
                }
                return false;
            }
        }
        int n = Math.max(this.maxFree - this.freeCount, this.maxIdle - this.idleCount);
        this.killSomeClients(n > 0 ? n : 1);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killSomeClients(int n) {
        SocketClientState socketClientState;
        int n2;
        int n3 = n2 = n > 0 ? n : Math.max(this.maxFree - this.freeCount, this.maxIdle - this.idleCount);
        while (--n2 >= 0 && (socketClientState = (SocketClientState)this.idleList.removeTail()) != null) {
            SocketClientState socketClientState2 = this.csList;
            synchronized (socketClientState2) {
                if (socketClientState.status == 0) {
                    this.decrIdleCount();
                    socketClientState.status = 3;
                    socketClientState.client.unbind();
                }
            }
            if (this.freeCount <= this.minFree || this.idleCount >= this.maxIdle) continue;
            break;
        }
    }

    protected final void killSomeClients() {
        this.killSomeClients(-1);
    }

    protected void run(SocketClient socketClient) {
        boolean bl = this.threadcache.getThread(socketClient, true);
    }

    public void handleConnection(Socket socket) {
        SocketClientState socketClientState = null;
        switch (this.loadavg) {
            case 1: {
                if (!this.decrFreeCount() || (socketClientState = (SocketClientState)this.freeList.removeTail()) != null) break;
                while (!this.incrFreeCount()) {
                }
                break;
            }
            case 2: 
            case 3: {
                this.killSomeClients();
                if (!this.decrFreeCount() || (socketClientState = (SocketClientState)this.freeList.removeTail()) != null) break;
                while (!this.incrFreeCount()) {
                }
                break;
            }
        }
        if (socketClientState != null) {
            socketClientState.status = 1;
            socketClientState.client.bind(socket);
        } else {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.server.errlog(socket.getInetAddress() + " refused (overloaded).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void killClients(boolean bl) {
        SocketClientState socketClientState;
        this.alive = false;
        SocketClientState socketClientState2 = this.csList;
        while (socketClientState2 != null && socketClientState2.client != null) {
            socketClientState = this.csList;
            synchronized (socketClientState) {
                socketClientState2.client.kill(socketClientState2.status == 0);
            }
            socketClientState2 = socketClientState2.csnext;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        socketClientState2 = this.csList;
        while (socketClientState2 != null && socketClientState2.client != null) {
            socketClientState = this.csList;
            synchronized (socketClientState) {
                socketClientState2.client.kill(true);
            }
            socketClientState2 = socketClientState2.csnext;
        }
    }

    public void shutdown(boolean bl) {
        this.killClients(bl);
        SocketClientState socketClientState = this.csList;
        while (socketClientState != null && socketClientState.client != null) {
            socketClientState.client.join();
            socketClientState = socketClientState.csnext;
        }
        this.props.unregisterObserver(this);
        this.props = null;
        this.csList = null;
        this.freeList = null;
        this.idleList = null;
        this.server = null;
    }

    public ServerSocket createServerSocket() throws IOException {
        if (this.bindAddr == null) {
            return new ServerSocket(this.server.getPort(), Math.max(128, this.maxClients));
        }
        return new ServerSocket(this.server.getPort(), Math.max(128, this.maxClients), this.bindAddr);
    }

    public void initialize(httpd httpd2) {
        this.server = httpd2;
        this.props = httpd2.getProperties();
        this.props.registerObserver(this);
        SocketConnectionProp socketConnectionProp = new SocketConnectionProp("SocketConnectionProp", httpd2);
        httpd2.registerPropertySet(socketConnectionProp);
        this.minFree = this.props.getInteger(MINSPARE_FREE_P, 5);
        this.maxFree = this.props.getInteger(MAXSPARE_FREE_P, 10);
        this.maxIdle = this.props.getInteger(MAXSPARE_IDLE_P, 20);
        this.maxClients = this.props.getInteger(MAXCLIENTS_P, 32);
        this.timeout = this.props.getInteger(TIMEOUT_P, 10000);
        String string = this.props.getString(BINDADDR_P, null);
        if (string != null) {
            try {
                this.bindAddr = InetAddress.getByName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.idleList = new SyncLRUList();
        this.freeList = new SyncLRUList();
        this.csList = new SocketClientState();
        for (int i = 0; i < this.maxClients; ++i) {
            if (this.addClient(true) != null) continue;
            throw new RuntimeException(this.getClass().getName() + "[construstructor]" + ": unable to create clients.");
        }
        this.threadcache = new ThreadCache(httpd2.getIdentifier() + "-socket-clients");
        this.threadcache.setCachesize(this.props.getInteger(MAXTHREADS_P, 40));
        this.threadcache.setThreadPriority(httpd2.getClientThreadPriority());
        this.threadcache.setIdleTimeout(this.props.getInteger(IDLETO_P, 10000));
        this.threadcache.setGrowAsNeeded(true);
        this.threadcache.initialize();
    }
}

