/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import javax.servlet.ServletException;
import org.w3c.jigsaw.servlet.ServletLoader;
import org.w3c.jigsaw.servlet.ServletWrapper;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.StringAttribute;

public class RemoteServletWrapper
extends ServletWrapper {
    private static final boolean debug = false;
    protected static int ATTR_SERVLET_BASE = -1;
    protected ServletLoader loader = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkServlet() throws ClassNotFoundException, ServletException {
        ServletWrapper.ServletPool servletPool = this.servletPool;
        synchronized (servletPool) {
            if (!this.inited) {
                this.inited = this.launchServlet();
            }
        }
    }

    protected synchronized ServletLoader getServletLoader() {
        if (this.loader == null) {
            this.loader = new ServletLoader(this);
        }
        return this.loader;
    }

    public String getServletBase() {
        return this.getString(ATTR_SERVLET_BASE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int n, Object object) {
        super.setValueOfSuperClass(n, object);
        try {
            ServletWrapper.ServletPool servletPool = this.servletPool;
            synchronized (servletPool) {
                if (n == ATTR_SERVLET_CLASS && object != null) {
                    this.inited = this.launchServlet();
                }
                if (n == ATTR_SERVLET_BASE && object != null) {
                    this.inited = this.launchServlet();
                }
            }
        }
        catch (Exception exception) {
            String string = "unable to set servlet class \"" + this.getServletClass() + "\" : " + exception.getMessage();
            this.getServer().errlog(string);
        }
    }

    protected boolean launchServlet() throws ClassNotFoundException, ServletException {
        this.destroyServlet();
        if (this.inited) {
            String string = "relaunching servlet failed due to incomplete \"" + this.getServletClass() + "\" cleanup.";
            this.getServer().errlog(this, string);
            return false;
        }
        Class clazz = null;
        try {
            clazz = this.getServletLoader().loadClass(this.getServletClass(), true);
        }
        catch (ClassFormatError classFormatError) {
            String string = "class \"" + this.getServletClass() + "\" loaded from " + this.getServletBase() + ", invalid format.";
            this.getServer().errlog(this, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = "class \"" + this.getServletClass() + "\" loaded from " + this.getServletBase() + ", not found.";
            this.getServer().errlog(this, string);
        }
        return clazz != null ? this.launchServlet(clazz) : false;
    }

    static {
        Class<?> clazz = null;
        StringAttribute stringAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.servlet.RemoteServletWrapper");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringAttribute = new StringAttribute("servlet-base", null, 6);
        ATTR_SERVLET_BASE = AttributeRegistry.registerAttribute(clazz, stringAttribute);
    }
}

