/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class SingleElementIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private boolean m_bHasNext = true;
    private final ELEMENTTYPE m_aElement;

    public SingleElementIterator(@Nullable ELEMENTTYPE aElement) {
        this.m_aElement = aElement;
    }

    @Override
    public boolean hasNext() {
        return this.m_bHasNext;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (this.m_bHasNext) {
            this.m_bHasNext = false;
            return this.m_aElement;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleElementIterator)) {
            return false;
        }
        SingleElementIterator rhs = (SingleElementIterator)o;
        return this.m_bHasNext == rhs.m_bHasNext && EqualsUtils.equals(this.m_aElement, rhs.m_aElement);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bHasNext).append(this.m_aElement).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hasNext", this.m_bHasNext).append("element", this.m_aElement).toString();
    }

    @Nonnull
    public static <T> Iterator<T> create(@Nullable T aElement) {
        return new SingleElementIterator<T>(aElement);
    }
}

