/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.XMLHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public final class FilterElementWithNamespaceAndLocalName
implements IFilter<Element> {
    private final String m_sNamespaceURI;
    private final String m_sLocalName;

    public FilterElementWithNamespaceAndLocalName(@Nullable String sNamespaceURI, @Nonnull @Nonempty String sLocalName) {
        if (StringHelper.hasNoText(sLocalName)) {
            throw new IllegalArgumentException("localName");
        }
        this.m_sNamespaceURI = sNamespaceURI;
        this.m_sLocalName = sLocalName;
    }

    @Override
    public boolean matchesFilter(@Nonnull Element aElement) {
        return XMLHelper.hasNamespaceURI(aElement, this.m_sNamespaceURI) && aElement.getLocalName().equals(this.m_sLocalName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterElementWithNamespaceAndLocalName)) {
            return false;
        }
        FilterElementWithNamespaceAndLocalName rhs = (FilterElementWithNamespaceAndLocalName)o;
        return EqualsUtils.equals(this.m_sNamespaceURI, rhs.m_sNamespaceURI) && this.m_sLocalName.equals(rhs.m_sLocalName);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sNamespaceURI).append(this.m_sLocalName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("namespaceURI", this.m_sNamespaceURI).append("localName", this.m_sLocalName).toString();
    }
}

