/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.admin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.w3c.jigsaw.admin.AdminContext;
import org.w3c.jigsaw.admin.AdminProtocolException;
import org.w3c.jigsaw.admin.AdminReader;
import org.w3c.jigsaw.admin.AdminServer;
import org.w3c.jigsaw.admin.AdminWriter;
import org.w3c.jigsaw.admin.ResourceBroker;
import org.w3c.jigsaw.daemon.ServerHandler;
import org.w3c.jigsaw.daemon.ServerHandlerManager;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.ContainerInterface;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.resources.serialization.ResourceDescription;

public class BrokerFrame
extends HTTPFrame {
    protected ResourceBroker broker = null;
    protected AdminWriter writer = null;
    protected ServerHandlerManager shm = null;
    protected AdminServer admin = null;

    public void registerResource(FramedResource framedResource) {
        super.registerResource(framedResource);
        if (framedResource instanceof ResourceBroker) {
            this.broker = (ResourceBroker)framedResource;
        }
    }

    protected void error(Request request, String string) throws ProtocolException {
        Reply reply = request.makeReply(500);
        reply.setContent(string);
        throw new HTTPException(reply);
    }

    protected Reply okReply(Request request, byte[] byArray) {
        Reply reply = request.makeReply(200);
        reply.setContentType(AdminContext.conftype);
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            reply.setContentLength(byArray.length);
            reply.setStream(byteArrayInputStream);
        }
        return reply;
    }

    protected Reply okReply(Request request) {
        return this.okReply(request, null);
    }

    protected void checkContentType(Request request) throws ProtocolException {
        if (request.getContentType().match(AdminContext.conftype) < 0) {
            this.error(request, "invalid MIME type: " + request.getContentType());
        }
    }

    protected InputStream getInputStream(Request request) throws ProtocolException {
        Client client = request.getClient();
        if (client != null) {
            try {
                client.sendContinue();
            }
            catch (IOException iOException) {
                throw new HTTPException(iOException.getMessage());
            }
        }
        try {
            if (request.hasTransferEncoding("gzip")) {
                return new GZIPInputStream(request.getInputStream());
            }
            return request.getInputStream();
        }
        catch (IOException iOException) {
            this.error(request, "invalid request");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceReference lookup(Request request) throws ProtocolException {
        LookupState lookupState = null;
        try {
            lookupState = new LookupState(request);
        }
        catch (ProtocolException protocolException) {
            protocolException.printStackTrace();
            throw new HTTPException(protocolException);
        }
        LookupResult lookupResult = new LookupResult(null);
        ResourceReference resourceReference = null;
        lookupState.markInternal();
        if (!lookupState.hasMoreComponents()) {
            return this.admin.getRootReference();
        }
        String string = lookupState.getNextComponent();
        ServerHandler serverHandler = this.shm.lookupServerHandler(string);
        if (serverHandler == null) {
            if (string.equals("realms")) {
                resourceReference = this.admin.getRealmCatalogResource();
            } else if (string.equals("control")) {
                resourceReference = this.admin.getControlResource();
            } else {
                this.error(request, "unknown server handler");
            }
        } else {
            resourceReference = serverHandler.getConfigResource();
        }
        if (resourceReference != null) {
            Object object;
            ResourceReference resourceReference2 = null;
            while (lookupState.hasMoreComponents()) {
                try {
                    if (resourceReference == null) {
                        this.error(request, "url too long");
                    }
                    if (!((object = resourceReference.lock()) instanceof ContainerInterface)) {
                        this.error(request, "url too long");
                    }
                    resourceReference2 = ((ContainerInterface)object).lookup(lookupState.getNextComponent());
                }
                catch (InvalidResourceException invalidResourceException) {
                    this.error(request, "unable to restore resource");
                }
                finally {
                    resourceReference.unlock();
                    resourceReference = resourceReference2;
                }
            }
            if (resourceReference == null) {
                this.error(request, "unknown resource");
            }
            if ((object = request.getQueryString()) != null) {
                Object object2;
                try {
                    object2 = resourceReference.lock();
                    if (!(object2 instanceof FramedResource)) {
                        this.error(request, "not a framed resource");
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                    this.error(request, "unable to restore resource");
                }
                finally {
                    resourceReference.unlock();
                }
                object2 = new LookupFrameState((String)object);
                String string2 = null;
                ResourceReference resourceReference3 = resourceReference;
                ResourceReference[] resourceReferenceArray = null;
                while (((LookupFrameState)object2).hasMoreComponents()) {
                    try {
                        resourceReferenceArray = ((FramedResource)resourceReference3.lock()).getFramesReference();
                        if (resourceReferenceArray == null) {
                            this.error(request, "unknown frame");
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        this.error(request, invalidResourceException.getMessage());
                    }
                    finally {
                        resourceReference3.unlock();
                    }
                    resourceReference3 = null;
                    string2 = ((LookupFrameState)object2).getNextComponent();
                    ResourceReference resourceReference4 = null;
                    ResourceFrame resourceFrame = null;
                    for (int i = 0; i < resourceReferenceArray.length; ++i) {
                        resourceReference4 = resourceReferenceArray[i];
                        try {
                            resourceFrame = (ResourceFrame)resourceReference4.lock();
                            if (!resourceFrame.getIdentifier().equals(string2)) continue;
                            resourceReference3 = resourceReference4;
                            break;
                        }
                        catch (InvalidResourceException invalidResourceException) {
                            this.error(request, invalidResourceException.getMessage());
                            continue;
                        }
                        finally {
                            resourceReference4.unlock();
                        }
                    }
                    if (resourceReference3 != null) continue;
                    this.error(request, "unknown frame");
                }
                return resourceReference3;
            }
            return resourceReference;
        }
        this.error(request, "unknown resource");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply remoteSetValues(Request request) throws ProtocolException {
        InputStream inputStream = this.getInputStream(request);
        ResourceReference resourceReference = this.lookup(request);
        try {
            Resource resource = resourceReference.lock();
            ResourceDescription resourceDescription = AdminReader.readResourceDescription(inputStream);
            AttributeDescription[] attributeDescriptionArray = resourceDescription.getAttributeDescriptions();
            for (int i = 0; i < attributeDescriptionArray.length; ++i) {
                AttributeDescription attributeDescription = attributeDescriptionArray[i];
                resource.setValue(attributeDescription.getName(), attributeDescription.getValue());
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            invalidResourceException.printStackTrace();
            this.error(request, "Invalid resource");
        }
        catch (IOException iOException) {
            this.error(request, "bad request");
        }
        catch (AdminProtocolException adminProtocolException) {
            this.error(request, adminProtocolException.getMessage());
        }
        finally {
            resourceReference.unlock();
        }
        return this.okReply(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply remoteLoadResource(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Resource resource = resourceReference.lock();
            this.writer.writeResource(resource, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            this.error(request, "bad request");
        }
        catch (InvalidResourceException invalidResourceException) {
            this.error(request, "Invalid resource");
        }
        catch (AdminProtocolException adminProtocolException) {
            this.error(request, adminProtocolException.getMessage());
        }
        finally {
            resourceReference.unlock();
        }
        return this.okReply(request, byteArrayOutputStream.toByteArray());
    }

    /*
     * Exception decompiling
     */
    public Reply remoteRegisterFrame(Request var1_1) throws ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Reply remoteUnregisterFrame(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        try {
            Resource resource = resourceReference.lock();
            if (!(resource instanceof FramedResource)) {
                this.error(request, "Can't unregister frames from a non-framed resource");
            }
            try {
                InputStream inputStream = this.getInputStream(request);
                ResourceDescription resourceDescription = AdminReader.readResourceDescription(inputStream);
                String string = resourceDescription.getIdentifier();
                ResourceFrame[] resourceFrameArray = ((FramedResource)resource).getFrames();
                for (int i = 0; i < resourceFrameArray.length; ++i) {
                    if (!resourceFrameArray[i].getIdentifier().equals(string)) continue;
                    ((FramedResource)resource).unregisterFrame(resourceFrameArray[i]);
                    Reply reply = this.okReply(request);
                    return reply;
                }
                this.error(request, "Frame " + string + " not registered");
                return null;
            }
            catch (IOException iOException) {
                this.error(request, "bad request");
                return null;
            }
            catch (AdminProtocolException adminProtocolException) {
                this.error(request, adminProtocolException.getMessage());
                return null;
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            this.error(request, "invalid resource");
            return null;
        }
        finally {
            resourceReference.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public Reply remoteRegisterResource(Request var1_1) throws ProtocolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply remoteReindexResource(Request request, boolean bl) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        try {
            Resource resource = resourceReference.lock();
            if (resource != null) {
                if (resource instanceof DirectoryResource) {
                    DirectoryResource directoryResource = (DirectoryResource)resource;
                    directoryResource.reindex(bl);
                    Reply reply = this.okReply(request);
                    return reply;
                }
                this.error(request, "Can't reindex this resource(not a DirectoryResource)");
            } else {
                this.error(request, "Bad request");
            }
        }
        catch (InvalidResourceException invalidResourceException) {
            this.error(request, "Invalid resource");
        }
        finally {
            resourceReference.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reply remoteDeleteResource(Request request) throws ProtocolException {
        ResourceReference resourceReference = this.lookup(request);
        try {
            Resource resource = resourceReference.lock();
            if (resource != null) {
                try {
                    resource.delete();
                }
                catch (MultipleLockException multipleLockException) {
                    this.error(request, multipleLockException.getMessage());
                }
                Reply reply = this.okReply(request);
                return reply;
            }
            this.error(request, "Bad request");
        }
        catch (InvalidResourceException invalidResourceException) {
            this.error(request, "Invalid resource");
        }
        finally {
            resourceReference.unlock();
        }
        return null;
    }

    public Reply extended(Request request) throws ProtocolException, ResourceException {
        String string = request.getMethod();
        if (string.equals("SET-VALUES")) {
            this.checkContentType(request);
            return this.remoteSetValues(request);
        }
        if (string.equals("LOAD-RESOURCE")) {
            return this.remoteLoadResource(request);
        }
        if (string.equals("REGISTER-RESOURCE")) {
            this.checkContentType(request);
            return this.remoteRegisterResource(request);
        }
        if (string.equals("DELETE-RESOURCE")) {
            return this.remoteDeleteResource(request);
        }
        if (string.equals("REINDEX-RESOURCE")) {
            return this.remoteReindexResource(request, true);
        }
        if (string.equals("REINDEX-LOCALLY")) {
            return this.remoteReindexResource(request, false);
        }
        if (string.equals("UNREGISTER-FRAME")) {
            this.checkContentType(request);
            return this.remoteUnregisterFrame(request);
        }
        if (string.equals("REGISTER-FRAME")) {
            this.checkContentType(request);
            return this.remoteRegisterFrame(request);
        }
        return super.extended(request);
    }

    protected Reply getOtherResource(Request request) throws ProtocolException, ResourceException {
        Reply reply = request.makeReply(501);
        reply.setContent("Method GET not implemented.<br><br>The administration server does not use plain HTTP but a variant of it. The only tool available for now is an application called <b>JigAdmin</b>. Please read the documentation.");
        throw new HTTPException(reply);
    }

    public BrokerFrame(ServerHandlerManager serverHandlerManager, AdminServer adminServer, AdminWriter adminWriter) {
        this.shm = serverHandlerManager;
        this.admin = adminServer;
        this.writer = adminWriter;
    }

    class LookupFrameState {
        private int index;
        private String[] components;

        void parseQuery(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "?");
            int n = stringTokenizer.countTokens();
            this.components = new String[n];
            for (int i = 0; i < n; ++i) {
                this.components[i] = stringTokenizer.nextToken();
            }
            this.index = 0;
        }

        public boolean hasMoreComponents() {
            return this.index < this.components.length;
        }

        public final String getNextComponent() {
            return this.components[this.index++];
        }

        LookupFrameState(String string) {
            this.parseQuery(string);
        }
    }
}

