/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pagecompile;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.pagecompile.GeneratedClassLoader;
import org.w3c.jigsaw.pagecompile.GeneratedFrame;
import org.w3c.jigsaw.pagecompile.PageCompileOutputStream;
import org.w3c.jigsaw.pagecompile.PageCompileProp;
import org.w3c.jigsaw.pagecompile.PageCompiler;
import org.w3c.jigsaw.pagecompile.Segment;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.util.ObservableProperties;
import org.w3c.www.mime.MimeType;

public class PageCompileFrame
extends HTTPFrame {
    private static final boolean debug = true;
    static Class generatedClass = null;
    private static byte[] startIncrements = new byte[128];
    private static byte[] endIncrements = new byte[128];
    private static byte[] startPat = new byte[]{60, 106, 97, 118, 97};
    private static byte[] endPat = new byte[]{60, 47, 106, 97, 118, 97, 62};
    private byte[] unparsed = null;
    protected static GeneratedClassLoader classloader = null;
    protected Segment[] classSegs = null;
    protected Segment[] importSegs = null;
    protected Segment[] extendsSegs = null;
    protected Segment[] implementsSegs = null;
    protected Segment[] bodySegs = null;
    private PageCompileProp props = null;
    private String gcname = null;
    private String packagename = null;
    private String packagedClassName = null;
    private File gcfile = null;
    private File ccfile = null;
    private PageCompiler compiler = null;

    protected static GeneratedClassLoader getClassLoader() {
        return classloader;
    }

    protected static void createClassLoader(File file) {
        if (classloader == null) {
            classloader = new GeneratedClassLoader(file);
        }
    }

    protected static GeneratedClassLoader getNewClassLoader() {
        classloader = new GeneratedClassLoader(classloader);
        return classloader;
    }

    protected PageCompileProp getPageCompileProps() {
        if (this.props == null) {
            httpd httpd2 = (httpd)this.getServer();
            this.props = (PageCompileProp)httpd2.getPropertySet(PageCompileProp.PAGE_COMPILE_PROP_NAME);
        }
        return this.props;
    }

    protected String getGeneratedClassName() {
        this.updateGeneratedClassAttributes();
        return this.gcname;
    }

    protected String getGeneratedPackageName() {
        this.updateGeneratedClassAttributes();
        return this.packagename;
    }

    protected String getPackagedClassName() {
        this.updateGeneratedClassAttributes();
        if (this.packagename == null) {
            return this.gcname;
        }
        return this.packagename + "." + this.gcname;
    }

    protected File getGeneratedClassFile() {
        this.updateGeneratedClassAttributes();
        return this.gcfile;
    }

    private File getCompiledClassFile() {
        this.updateGeneratedClassAttributes();
        return this.ccfile;
    }

    private void updateGeneratedClassAttributes() {
        if (this.gcname == null || this.gcfile == null) {
            int n;
            File file = this.getPageCompileProps().getCompiledPageDirectory();
            String string = this.fresource.getURLPath();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            if ((n = string.lastIndexOf(47)) != -1) {
                this.gcname = string.substring(n + 1);
                File file2 = null;
                if (n != 0) {
                    String string2 = string.substring(0, n);
                    this.packagename = string2.substring(1);
                    this.packagename = this.packagename.replace('/', '.');
                    file2 = new File(file, string2.substring(1));
                } else {
                    file2 = file;
                    this.packagename = null;
                }
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                this.gcfile = new File(file2, this.gcname + ".java");
                this.ccfile = new File(file2, this.gcname + ".class");
            } else {
                throw new RuntimeException("Can't update generated class attributes from url : " + this.fresource.getURLPath());
            }
        }
    }

    protected boolean classCompiled() {
        return this.getCompiledClassFile().exists();
    }

    protected PageCompiler getCompiler() {
        try {
            String string = this.getPageCompileProps().getCompilerClassName();
            Class<?> clazz = Class.forName(string);
            return (PageCompiler)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResource(FramedResource framedResource) {
        Serializable serializable;
        super.registerResource(framedResource);
        if (this.getPageCompileProps() == null) {
            serializable = this.getClass();
            synchronized (serializable) {
                httpd httpd2 = (httpd)this.getServer();
                if (httpd2 != null) {
                    ObservableProperties observableProperties = httpd2.getProperties();
                    httpd2.registerPropertySet(new PageCompileProp(httpd2));
                }
            }
        }
        serializable = this.getPageCompileProps().getCompiledPageDirectory();
        PageCompileFrame.createClassLoader(serializable);
    }

    protected byte[] readUnparsed() throws IOException {
        File file = this.fresource.getFile();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        byteArrayOutputStream.close();
        this.unparsed = byteArrayOutputStream.toByteArray();
        return this.unparsed;
    }

    public static final boolean byteArrayNEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n3 + n;
        for (int i = n; i < n5; ++i) {
            if (byArray[i] == byArray2[i + n4]) continue;
            return false;
        }
        return true;
    }

    private final boolean isSpace(byte by) {
        return by == 32 || by == 9 || by == 10 || by == 13;
    }

    private final boolean isSpaceOrEqual(byte by) {
        return by == 32 || by == 9 || by == 10 || by == 13 || by == 61;
    }

    protected int parseType(byte[] byArray, int n, int n2) {
        char c;
        int n3;
        StringBuffer stringBuffer = new StringBuffer(10);
        StringBuffer stringBuffer2 = new StringBuffer(10);
        Object var6_6 = null;
        for (n3 = n; n3 <= n2 && this.isSpace(byArray[n3]); ++n3) {
        }
        while (n3 <= n2 && !this.isSpaceOrEqual(byArray[n3])) {
            c = (char)byArray[n3++];
            stringBuffer.append(c);
        }
        if (!stringBuffer.toString().equalsIgnoreCase("type")) {
            return Segment.getDefaultType();
        }
        while (n3 <= n2 && this.isSpaceOrEqual(byArray[n3])) {
            ++n3;
        }
        while (n3 <= n2 && !this.isSpace(byArray[n3])) {
            c = (char)byArray[n3++];
            stringBuffer2.append(c);
        }
        return Segment.getType(stringBuffer2.toString());
    }

    protected Segment[] parse() {
        this.unparsed = null;
        try {
            this.unparsed = this.readUnparsed();
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<Segment> vector = new Vector<Segment>(20);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        do {
            byte by;
            n += 4;
            while (!(n >= this.unparsed.length || (by = this.unparsed[n]) == 97 && PageCompileFrame.byteArrayNEquals(this.unparsed, n - 4, startPat, 0, 4))) {
                n += startIncrements[by >= 0 ? by : (byte)0];
            }
            if (++n >= this.unparsed.length) break;
            if (n > 6) {
                vector.addElement(new Segment(n2, n - 6));
            }
            n3 = n;
            while (n < this.unparsed.length && this.unparsed[n] != 62) {
                ++n;
            }
            if (++n >= this.unparsed.length) break;
            n4 = this.parseType(this.unparsed, n3, n - 2);
            n2 = n;
            n += 6;
            while (!(n >= this.unparsed.length || (by = this.unparsed[n]) == 62 && PageCompileFrame.byteArrayNEquals(this.unparsed, n - 6, endPat, 0, 6))) {
                n += endIncrements[by >= 0 ? by : (byte)0];
            }
            if (++n >= this.unparsed.length) break;
            vector.addElement(new Segment(n2, n - 8, n4));
            n2 = n;
        } while (n < this.unparsed.length);
        vector.addElement(new Segment(n2, this.unparsed.length));
        Object[] objectArray = new Segment[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Segment[] getSegmentArrayFromVector(Vector vector) {
        int n = vector.size();
        if (n < 1) {
            return null;
        }
        Object[] objectArray = new Segment[n];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected void separateSegments(Segment[] segmentArray) {
        Vector<Segment> vector = new Vector<Segment>(3);
        Vector<Segment> vector2 = new Vector<Segment>(3);
        Vector<Segment> vector3 = new Vector<Segment>(1);
        Vector<Segment> vector4 = new Vector<Segment>(1);
        Vector<Segment> vector5 = new Vector<Segment>(5);
        block6: for (int i = 0; i < segmentArray.length; ++i) {
            switch (segmentArray[i].getType()) {
                case 5: {
                    vector.addElement(segmentArray[i]);
                    continue block6;
                }
                case 2: {
                    vector2.addElement(segmentArray[i]);
                    continue block6;
                }
                case 3: {
                    vector3.addElement(segmentArray[i]);
                    continue block6;
                }
                case 4: {
                    vector4.addElement(segmentArray[i]);
                    continue block6;
                }
                default: {
                    vector5.addElement(segmentArray[i]);
                }
            }
        }
        this.classSegs = this.getSegmentArrayFromVector(vector);
        this.importSegs = this.getSegmentArrayFromVector(vector2);
        this.extendsSegs = this.getSegmentArrayFromVector(vector3);
        this.implementsSegs = this.getSegmentArrayFromVector(vector4);
        this.bodySegs = this.getSegmentArrayFromVector(vector5);
    }

    protected byte[] getPackageStatement() {
        if (this.getGeneratedPackageName() != null) {
            return new String("package " + this.getGeneratedPackageName() + ";\n\n").getBytes();
        }
        return null;
    }

    protected byte[] getClassDeclarationStatement() {
        return new String("public class " + this.getGeneratedClassName() + " extends ").getBytes();
    }

    protected String getFilePath() {
        String string = this.fresource.getFile().getAbsolutePath();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(92);
        if (n == -1) {
            return string;
        }
        while ((n = string.indexOf(92)) != -1) {
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append("\\\\");
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected byte[] getGetMethodDeclaration() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("    protected void get(org.w3c.jigsaw.http.Request request,\n");
        stringBuffer.append("                       org.w3c.jigsaw.http.Reply reply,\n");
        stringBuffer.append("                       org.w3c.jigsaw.pagecompile.PageCompileOutputStream out)\n");
        stringBuffer.append("        throws java.io.IOException\n");
        stringBuffer.append("    {\n");
        stringBuffer.append("        org.w3c.jigsaw.pagecompile.PageCompileFile _file = new org.w3c.jigsaw.pagecompile.PageCompileFile(\"");
        stringBuffer.append(this.getFilePath() + "\");\n");
        return stringBuffer.toString().getBytes();
    }

    protected byte[] getClassEnd() {
        byte[] byArray = new byte[]{32, 32, 32, 32, 125, 10, 125};
        return byArray;
    }

    protected byte[] getSegmentBytes(Segment segment) {
        if (segment.getType() == 6) {
            byte[] byArray = new String("        out.print(String.valueOf(").getBytes();
            byte[] byArray2 = new byte[]{41, 41, 59, 10};
            int n = segment.end - segment.start + 1;
            int n2 = byArray.length + n + byArray2.length;
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(this.unparsed, segment.start, byArray3, byArray.length, n);
            System.arraycopy(byArray2, 0, byArray3, byArray.length + n, byArray2.length);
            return byArray3;
        }
        if (segment.getType() != 7) {
            int n = segment.end - segment.start + 1;
            byte[] byArray = new byte[n];
            System.arraycopy(this.unparsed, segment.start, byArray, 0, n);
            return byArray;
        }
        return new String("        _file.writeBytes(" + segment.start + "," + segment.end + ",out);\n").getBytes();
    }

    public GeneratedFrame generateFrame(Request request) throws ResourceException, ProtocolException {
        PageCompileOutputStream pageCompileOutputStream;
        Object[] objectArray;
        Object object;
        this.separateSegments(this.parse());
        File file = this.getGeneratedClassFile();
        if (file.exists()) {
            file.delete();
        }
        if (this.getCompiledClassFile().exists()) {
            this.getCompiledClassFile().delete();
        }
        try {
            int n;
            object = new BufferedOutputStream(new FileOutputStream(file));
            objectArray = this.getPackageStatement();
            if (objectArray != null) {
                ((FilterOutputStream)object).write((byte[])objectArray);
            }
            if (this.importSegs != null) {
                for (n = 0; n < this.importSegs.length; ++n) {
                    ((FilterOutputStream)object).write(this.getSegmentBytes(this.importSegs[n]));
                }
                ((BufferedOutputStream)object).write(10);
            }
            ((FilterOutputStream)object).write(this.getClassDeclarationStatement());
            if (this.extendsSegs != null) {
                if (this.extendsSegs.length > 0) {
                    ((FilterOutputStream)object).write(this.getSegmentBytes(this.extendsSegs[0]));
                }
                ((BufferedOutputStream)object).write(32);
            } else {
                ((FilterOutputStream)object).write(new String("org.w3c.jigsaw.pagecompile.GeneratedFrame ").getBytes());
            }
            if (this.implementsSegs != null && this.implementsSegs.length > 0) {
                byte[] byArray = new byte[]{105, 109, 112, 108, 101, 109, 101, 110, 116, 115, 32};
                ((FilterOutputStream)object).write(byArray);
                ((FilterOutputStream)object).write(this.getSegmentBytes(this.implementsSegs[0]));
            }
            ((BufferedOutputStream)object).write(32);
            ((BufferedOutputStream)object).write(123);
            ((BufferedOutputStream)object).write(10);
            ((BufferedOutputStream)object).write(10);
            if (this.classSegs != null) {
                for (n = 0; n < this.classSegs.length; ++n) {
                    ((FilterOutputStream)object).write(this.getSegmentBytes(this.classSegs[n]));
                }
                ((BufferedOutputStream)object).write(10);
            }
            ((FilterOutputStream)object).write(this.getGetMethodDeclaration());
            if (this.bodySegs != null) {
                for (n = 0; n < this.bodySegs.length; ++n) {
                    ((FilterOutputStream)object).write(this.getSegmentBytes(this.bodySegs[n]));
                }
            }
            ((FilterOutputStream)object).write(this.getClassEnd());
            ((BufferedOutputStream)object).flush();
            ((FilterOutputStream)object).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.getCompiler();
        if (object == null) {
            throw new ResourceException("Can't load compiler: " + this.getPageCompileProps().getCompilerClassName());
        }
        objectArray = new String[]{file.getAbsolutePath()};
        if (!object.compile((String[])objectArray, pageCompileOutputStream = new PageCompileOutputStream()) && pageCompileOutputStream.size() > 0) {
            Reply reply = request.makeReply(500);
            reply.setStream(pageCompileOutputStream.getInputStream());
            reply.setContentLength(pageCompileOutputStream.size());
            reply.setContentType(MimeType.TEXT_PLAIN);
            throw new HTTPException(reply);
        }
        try {
            GeneratedClassLoader generatedClassLoader = PageCompileFrame.getClassLoader();
            if (generatedClassLoader.classChanged(this.getPackagedClassName())) {
                generatedClassLoader = PageCompileFrame.getNewClassLoader();
            }
            Class<?> clazz = generatedClassLoader.loadClass(this.getPackagedClassName());
            GeneratedFrame generatedFrame = (GeneratedFrame)clazz.newInstance();
            return generatedFrame;
        }
        catch (Exception exception) {
            throw new ResourceException(exception.getMessage());
        }
    }

    protected void registerNewGeneratedFrame(Request request) throws ResourceException, ProtocolException {
        ResourceFrame[] resourceFrameArray = this.collectFrames(generatedClass);
        if (resourceFrameArray != null) {
            for (int i = 0; i < resourceFrameArray.length; ++i) {
                this.unregisterFrame(resourceFrameArray[i]);
            }
        }
        GeneratedFrame generatedFrame = null;
        generatedFrame = this.generateFrame(request);
        if (generatedFrame != null) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(3);
            hashtable.put("identifier", "generated-frame");
            hashtable.put("content-type", MimeType.TEXT_HTML);
            this.registerFrame(generatedFrame, hashtable);
        }
    }

    protected void checkContent(Request request) throws ResourceException, ProtocolException {
        if (this.fresource != null) {
            File file = this.fresource.getFile();
            long l = file.lastModified();
            long l2 = this.fresource.getFileStamp();
            if (!this.classCompiled() || l2 < 0L || l2 < l) {
                this.fresource.updateFileAttributes();
                this.registerNewGeneratedFrame(request);
            }
        }
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        if (!this.checkRequest(requestInterface)) {
            return null;
        }
        this.checkContent((Request)requestInterface);
        return super.perform(requestInterface);
    }

    static {
        try {
            generatedClass = Class.forName("org.w3c.jigsaw.pagecompile.GeneratedFrame");
        }
        catch (Exception exception) {
            throw new RuntimeException("No GeneratedFrame class found.");
        }
        for (int i = 0; i < 128; ++i) {
            PageCompileFrame.startIncrements[i] = 5;
            PageCompileFrame.endIncrements[i] = 7;
        }
        PageCompileFrame.startIncrements[60] = 4;
        PageCompileFrame.startIncrements[106] = 3;
        PageCompileFrame.startIncrements[97] = 2;
        PageCompileFrame.startIncrements[118] = 1;
        PageCompileFrame.endIncrements[60] = 6;
        PageCompileFrame.endIncrements[47] = 5;
        PageCompileFrame.endIncrements[106] = 4;
        PageCompileFrame.endIncrements[97] = 1;
        PageCompileFrame.endIncrements[118] = 2;
    }
}

