/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.iterate;

import com.phloc.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReverseListIterator<ELEMENTTYPE>
implements Iterator<ELEMENTTYPE> {
    private final List<ELEMENTTYPE> m_aList;
    private int m_nIndex;

    public ReverseListIterator(@Nonnull List<ELEMENTTYPE> aList) {
        if (aList == null) {
            throw new NullPointerException("list");
        }
        this.m_aList = aList;
        this.m_nIndex = aList.size() - 1;
    }

    @Override
    public boolean hasNext() {
        return this.m_nIndex >= 0;
    }

    @Override
    @Nullable
    public ELEMENTTYPE next() {
        if (this.m_nIndex < 0) {
            throw new NoSuchElementException();
        }
        ELEMENTTYPE ret = this.m_aList.get(this.m_nIndex);
        --this.m_nIndex;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return new ToStringGenerator(this).append("list", this.m_aList).append("index", this.m_nIndex).toString();
    }
}

