/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.error;

import com.phloc.commons.ICloneable;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.IClearable;
import com.phloc.commons.string.ToStringGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ResourceErrorGroup
implements IResourceErrorGroup,
ICloneable<ResourceErrorGroup>,
IClearable {
    private final List<IResourceError> m_aErrors = new ArrayList<IResourceError>();

    public ResourceErrorGroup() {
    }

    public ResourceErrorGroup(IResourceError ... aResourceErrors) {
        if (aResourceErrors == null) {
            throw new NullPointerException("resourceErrors");
        }
        for (IResourceError aResourceError : aResourceErrors) {
            if (aResourceError == null) {
                throw new NullPointerException("resourceError");
            }
            this.m_aErrors.add(aResourceError);
        }
    }

    public ResourceErrorGroup(@Nonnull Iterable<? extends IResourceError> aResourceErrors) {
        if (aResourceErrors == null) {
            throw new NullPointerException("resourceErrors");
        }
        for (IResourceError iResourceError : aResourceErrors) {
            if (iResourceError == null) {
                throw new NullPointerException("resourceError");
            }
            this.m_aErrors.add(iResourceError);
        }
    }

    @Nonnull
    public ResourceErrorGroup addResourceError(@Nonnull IResourceError aResourceError) {
        if (aResourceError == null) {
            throw new NullPointerException("resourceError");
        }
        this.m_aErrors.add(aResourceError);
        return this;
    }

    @Nonnull
    public ResourceErrorGroup addResourceErrorGroup(@Nonnull IResourceErrorGroup aResourceErrorGroup) {
        if (aResourceErrorGroup == null) {
            throw new NullPointerException("resourceErrorGroup");
        }
        this.m_aErrors.addAll(aResourceErrorGroup.getAllResourceErrors());
        return this;
    }

    @Override
    public boolean containsOnlySuccess() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isFailure()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isSuccess()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        int ret = 0;
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isSuccess()) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public boolean containsOnlyFailure() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isSuccess()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isFailure()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        int ret = 0;
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isFailure()) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public boolean containsOnlyError() {
        if (this.m_aErrors.isEmpty()) {
            return false;
        }
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isNoError()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAtLeastOneError() {
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        int ret = 0;
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isError()) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getAllFailures() {
        ResourceErrorGroup ret = new ResourceErrorGroup();
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isFailure()) continue;
            ret.addResourceError(aError);
        }
        return ret;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ResourceErrorGroup getAllErrors() {
        ResourceErrorGroup ret = new ResourceErrorGroup();
        for (IResourceError aError : this.m_aErrors) {
            if (!aError.isError()) continue;
            ret.addResourceError(aError);
        }
        return ret;
    }

    @Override
    @Nonnull
    public EErrorLevel getMostSevereErrorLevel() {
        EErrorLevel eRet = EErrorLevel.SUCCESS;
        for (IResourceError aError : this.m_aErrors) {
            if (eRet != null && !aError.getErrorLevel().isMoreSevereThan(eRet)) continue;
            eRet = aError.getErrorLevel();
        }
        return eRet;
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aErrors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aErrors.isEmpty();
    }

    @Override
    @Nonnull
    public ResourceErrorGroup getClone() {
        return new ResourceErrorGroup(this.m_aErrors);
    }

    @Override
    @Nonnull
    public Iterator<IResourceError> iterator() {
        return this.m_aErrors.iterator();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<IResourceError> getAllResourceErrors() {
        return ContainerHelper.newList(this.m_aErrors);
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aErrors.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aErrors.clear();
        return EChange.CHANGED;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceErrorGroup)) {
            return false;
        }
        ResourceErrorGroup rhs = (ResourceErrorGroup)o;
        return ((Object)this.m_aErrors).equals(rhs.m_aErrors);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aErrors)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("errors", this.m_aErrors).toString();
    }
}

