/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.graph.simple;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.graph.IGraphNode;
import com.phloc.commons.graph.IGraphObjectFactory;
import com.phloc.commons.graph.IGraphRelation;
import com.phloc.commons.graph.iterate.GraphIteratorForward;
import com.phloc.commons.graph.simple.ISimpleGraph;
import com.phloc.commons.graph.simple.SimpleGraphObjectFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.ETriState;
import com.phloc.commons.string.ToStringGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleGraph<VALUETYPE>
implements ISimpleGraph<VALUETYPE> {
    public static final boolean DEFAULT_CHANGING_CONNECTED_OBJECTS_ALLOWED = true;
    private IGraphObjectFactory<VALUETYPE> m_aFactory;
    private final Map<String, IGraphNode<VALUETYPE>> m_aNodes = new HashMap<String, IGraphNode<VALUETYPE>>();
    private boolean m_bIsChangingConnectedObjectsAllowed = true;
    private ETriState m_eCacheHasCycles = ETriState.UNDEFINED;

    public SimpleGraph() {
        this(new SimpleGraphObjectFactory());
    }

    public SimpleGraph(@Nonnull IGraphObjectFactory<VALUETYPE> aFactory) {
        if (aFactory == null) {
            throw new NullPointerException("factory");
        }
        this.m_aFactory = aFactory;
    }

    private void _invalidateCache() {
        this.m_eCacheHasCycles = ETriState.UNDEFINED;
    }

    @Override
    public void setChangingConnectedObjectsAllowed(boolean bIsChangingConnectedObjectsAllowed) {
        this.m_bIsChangingConnectedObjectsAllowed = bIsChangingConnectedObjectsAllowed;
    }

    @Override
    public boolean isChangingConnectedObjectsAllowed() {
        return this.m_bIsChangingConnectedObjectsAllowed;
    }

    @Override
    @Nonnull
    public IGraphNode<VALUETYPE> createNode() {
        return this.createNode(null);
    }

    @Override
    @Nonnull
    public IGraphNode<VALUETYPE> createNode(@Nullable VALUETYPE aValue) {
        IGraphNode<VALUETYPE> aNode = this.m_aFactory.createNode(aValue);
        if (this.addNode(aNode).isUnchanged()) {
            throw new IllegalStateException("The ID factory created the ID '" + (String)aNode.getID() + "' that is already in use");
        }
        return aNode;
    }

    @Override
    @Nullable
    public IGraphNode<VALUETYPE> createNode(@Nullable String sID, @Nullable VALUETYPE aValue) {
        IGraphNode<VALUETYPE> aNode = this.m_aFactory.createNode(sID, aValue);
        return this.addNode(aNode).isChanged() ? aNode : null;
    }

    @Override
    @Nonnull
    public EChange addNode(@Nonnull IGraphNode<VALUETYPE> aNode) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (!this.isChangingConnectedObjectsAllowed() && aNode.hasIncomingOrOutgoingRelations()) {
            throw new IllegalArgumentException("The node to be added already has incoming and/or outgoing relations and this is not allowed!");
        }
        String sID = (String)aNode.getID();
        if (this.m_aNodes.containsKey(sID)) {
            return EChange.UNCHANGED;
        }
        this.m_aNodes.put(sID, aNode);
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeNode(@Nonnull IGraphNode<VALUETYPE> aNode) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (!this.isChangingConnectedObjectsAllowed() && aNode.hasIncomingOrOutgoingRelations()) {
            throw new IllegalArgumentException("The node to be removed already has incoming and/or outgoing relations and this is not allowed!");
        }
        if (this.m_aNodes.remove(aNode.getID()) == null) {
            return EChange.UNCHANGED;
        }
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Nonnull
    private IGraphRelation<VALUETYPE> _connect(@Nonnull IGraphRelation<VALUETYPE> aRelation) {
        aRelation.getFrom().addOutgoingRelation(aRelation);
        aRelation.getTo().addIncomingRelation(aRelation);
        return aRelation;
    }

    @Override
    @Nonnull
    public IGraphRelation<VALUETYPE> createRelation(@Nonnull String sFromNodeID, @Nonnull String sToNodeID) {
        IGraphNode<VALUETYPE> aFromNode = this.getNodeOfID(sFromNodeID);
        if (aFromNode == null) {
            throw new IllegalArgumentException("Failed to resolve from node ID '" + sFromNodeID + "'");
        }
        IGraphNode<VALUETYPE> aToNode = this.getNodeOfID(sToNodeID);
        if (aToNode == null) {
            throw new IllegalArgumentException("Failed to resolve to node ID '" + sToNodeID + "'");
        }
        return this.createRelation(aFromNode, aToNode);
    }

    @Override
    @Nonnull
    public IGraphRelation<VALUETYPE> createRelation(@Nonnull IGraphNode<VALUETYPE> aFrom, @Nonnull IGraphNode<VALUETYPE> aTo) {
        return this._connect(this.m_aFactory.createRelation(aFrom, aTo));
    }

    @Override
    @Nonnull
    public IGraphRelation<VALUETYPE> createRelation(@Nullable String sID, @Nonnull IGraphNode<VALUETYPE> aFrom, @Nonnull IGraphNode<VALUETYPE> aTo) {
        return this._connect(this.m_aFactory.createRelation(sID, aFrom, aTo));
    }

    @Override
    @Nonnull
    public IGraphNode<VALUETYPE> getSingleStartNode() throws IllegalStateException {
        Set<IGraphNode<VALUETYPE>> aStartNodes = this.getAllStartNodes();
        if (aStartNodes.size() > 1) {
            throw new IllegalStateException("Graph has more than one starting node");
        }
        if (aStartNodes.isEmpty()) {
            throw new IllegalStateException("Graph has no starting node");
        }
        return ContainerHelper.getFirstElement(aStartNodes);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<IGraphNode<VALUETYPE>> getAllStartNodes() {
        HashSet<IGraphNode<VALUETYPE>> aResult = new HashSet<IGraphNode<VALUETYPE>>();
        for (IGraphNode<VALUETYPE> aNode : this.m_aNodes.values()) {
            if (aNode.hasIncomingRelations()) continue;
            aResult.add(aNode);
        }
        return aResult;
    }

    @Override
    @Nonnull
    public IGraphNode<VALUETYPE> getSingleEndNode() throws IllegalStateException {
        Set<IGraphNode<VALUETYPE>> aEndNodes = this.getAllEndNodes();
        if (aEndNodes.size() > 1) {
            throw new IllegalStateException("Graph has more than one ending node");
        }
        if (aEndNodes.isEmpty()) {
            throw new IllegalStateException("Graph has no ending node");
        }
        return ContainerHelper.getFirstElement(aEndNodes);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<IGraphNode<VALUETYPE>> getAllEndNodes() {
        HashSet<IGraphNode<VALUETYPE>> aResult = new HashSet<IGraphNode<VALUETYPE>>();
        for (IGraphNode<VALUETYPE> aNode : this.m_aNodes.values()) {
            if (aNode.hasOutgoingRelations()) continue;
            aResult.add(aNode);
        }
        return aResult;
    }

    @Override
    @Nullable
    public IGraphNode<VALUETYPE> getNodeOfID(@Nullable String sID) {
        return this.m_aNodes.get(sID);
    }

    @Override
    @Nonnegative
    public int getNodeCount() {
        return this.m_aNodes.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public Set<IGraphNode<VALUETYPE>> getAllNodes() {
        return ContainerHelper.newSet(this.m_aNodes.values());
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (this.m_aNodes.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aNodes.clear();
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Override
    public boolean containsCycles() {
        if (this.m_eCacheHasCycles.isUndefined()) {
            this.m_eCacheHasCycles = ETriState.FALSE;
            Set<IGraphNode<VALUETYPE>> aNodes = this.getAllStartNodes();
            if (aNodes.isEmpty()) {
                aNodes = new HashSet<IGraphNode<VALUETYPE>>(this.m_aNodes.values());
            }
            for (IGraphNode<VALUETYPE> aCurNode : aNodes) {
                GraphIteratorForward<VALUETYPE> it = GraphIteratorForward.create(aCurNode);
                while (it.hasNext() && !it.hasCycles()) {
                    it.next();
                }
                if (!it.hasCycles()) continue;
                this.m_eCacheHasCycles = ETriState.TRUE;
                break;
            }
        }
        return this.m_eCacheHasCycles.getAsBooleanValue(true);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleGraph)) {
            return false;
        }
        SimpleGraph rhs = (SimpleGraph)o;
        return ((Object)this.m_aNodes).equals(rhs.m_aNodes);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Map)this.m_aNodes)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("nodes", this.m_aNodes).append("hasCycles", this.m_eCacheHasCycles).toString();
    }

    @Nonnull
    public static <VALUETYPE> SimpleGraph<VALUETYPE> create() {
        return new SimpleGraph<VALUETYPE>();
    }

    @Nonnull
    public static <VALUETYPE> SimpleGraph<VALUETYPE> create(@Nonnull IGraphObjectFactory<VALUETYPE> aFactory) {
        return new SimpleGraph<VALUETYPE>(aFactory);
    }
}

