/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streamprovider;

import com.phloc.commons.io.IReaderProvider;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class StringReaderProvider
implements IReaderProvider {
    private final String m_sData;

    public StringReaderProvider(@Nonnull char[] aChars) {
        this(new String(aChars));
    }

    public StringReaderProvider(@Nonnull char[] aChars, @Nonnegative int nOfs, @Nonnegative int nLength) {
        this(new String(aChars, nOfs, nLength));
    }

    public StringReaderProvider(@Nonnull CharSequence aData) {
        this(((Object)aData).toString());
    }

    public StringReaderProvider(@Nonnull String sData) {
        if (sData == null) {
            throw new NullPointerException("data");
        }
        this.m_sData = sData;
    }

    @Nonnull
    public String getData() {
        return this.m_sData;
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).toString();
    }
}

