/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.regex;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.regex.RegExPool;
import com.phloc.commons.string.StringHelper;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RegExHelper {
    private static final RegExHelper s_aInstance = new RegExHelper();

    private RegExHelper() {
    }

    @Nonnull
    public static String[] getSplitToArray(@Nullable CharSequence sText, @Nonnull @RegEx String sRegEx) {
        if (sText == null) {
            return new String[0];
        }
        return RegExPool.getPattern(sRegEx).split(sText);
    }

    @Nonnull
    public static String[] getSplitToArray(@Nullable CharSequence sText, @Nonnull @RegEx String sRegEx, @Nonnegative int nLimit) {
        if (sRegEx == null) {
            throw new IllegalArgumentException("regexp");
        }
        if (sText == null) {
            return new String[0];
        }
        return RegExPool.getPattern(sRegEx).split(sText, nLimit);
    }

    @Nonnull
    public static List<String> getSplitToList(@Nullable CharSequence sText, @Nonnull @RegEx String sRegEx) {
        return ContainerHelper.newList(RegExHelper.getSplitToArray(sText, sRegEx));
    }

    @Nonnull
    public static List<String> getSplitToList(@Nullable CharSequence sText, @Nonnull @RegEx String sRegEx, @Nonnegative int nLimit) {
        return ContainerHelper.newList(RegExHelper.getSplitToArray(sText, sRegEx, nLimit));
    }

    @Nonnull
    public static Matcher getMatcher(@Nonnull @RegEx String sRegEx, @Nonnull String sValue) {
        if (sValue == null) {
            throw new NullPointerException("value");
        }
        return RegExPool.getPattern(sRegEx).matcher(sValue);
    }

    @Nonnull
    public static Matcher getMatcher(@Nonnull @RegEx String sRegEx, @Nonnegative int nOptions, @Nonnull String sValue) {
        if (sValue == null) {
            throw new NullPointerException("value");
        }
        return RegExPool.getPattern(sRegEx, nOptions).matcher(sValue);
    }

    public static boolean stringMatchesPattern(@Nonnull @RegEx String sRegEx, @Nonnull String sValue) {
        return RegExHelper.getMatcher(sRegEx, sValue).matches();
    }

    public static boolean stringMatchesPattern(@Nonnull @RegEx String sRegEx, @Nonnegative int nOptions, @Nonnull String sValue) {
        return RegExHelper.getMatcher(sRegEx, nOptions, sValue).matches();
    }

    @Nonnull
    public static String stringReplacePattern(@Nonnull @RegEx String sRegEx, @Nonnull String sValue, @Nullable String sReplacement) {
        return RegExHelper.getMatcher(sRegEx, sValue).replaceAll(StringHelper.getNotNull(sReplacement));
    }

    @Nonnull
    public static String stringReplacePattern(@Nonnull @RegEx String sRegEx, @Nonnegative int nOptions, @Nonnull String sValue, @Nullable String sReplacement) {
        return RegExHelper.getMatcher(sRegEx, nOptions, sValue).replaceAll(StringHelper.getNotNull(sReplacement));
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String s) {
        return RegExHelper.getAsIdentifier(s, "_");
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String s, char cReplacement) {
        if (StringHelper.hasNoText(s)) {
            return s;
        }
        String sReplacement = Character.toString(cReplacement);
        String ret = RegExHelper.stringReplacePattern("\\W", s, Pattern.quote(sReplacement));
        if (!Character.isJavaIdentifierStart(ret.charAt(0))) {
            return sReplacement + ret;
        }
        return ret;
    }

    @Nullable
    public static String getAsIdentifier(@Nullable String s, @Nonnull String sReplacement) {
        if (sReplacement == null) {
            throw new NullPointerException("replacement");
        }
        if (StringHelper.hasNoText(s)) {
            return s;
        }
        String ret = RegExHelper.stringReplacePattern("\\W", s, sReplacement);
        if (ret.length() == 0) {
            return sReplacement;
        }
        if (!Character.isJavaIdentifierStart(ret.charAt(0))) {
            return sReplacement + ret;
        }
        return ret;
    }

    public static boolean isValidPattern(@Nonnull @RegEx String sRegEx) {
        try {
            Pattern.compile(sRegEx);
            return true;
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    @Nullable
    public static String[] getAllMatchingGroupValues(@Nonnull @RegEx String sRegEx, @Nonnull String sValue) {
        Matcher aMatcher = RegExHelper.getMatcher(sRegEx, sValue);
        if (!aMatcher.find()) {
            return null;
        }
        int nGroupCount = aMatcher.groupCount();
        String[] ret = new String[nGroupCount];
        for (int i = 0; i < nGroupCount; ++i) {
            ret[i] = aMatcher.group(i + 1);
        }
        return ret;
    }
}

