/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.string;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.math.MathHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForSigned;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringHelper {
    public static final int STRING_NOT_FOUND = -1;
    private static final int[] s_aSizeTableInt = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] s_aSizeTableLong = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};
    private static final StringHelper s_aInstance = new StringHelper();

    private StringHelper() {
    }

    public static boolean hasNoText(@Nullable CharSequence aCS) {
        return aCS == null || aCS.length() == 0;
    }

    public static boolean isEmpty(@Nullable CharSequence aCS) {
        return StringHelper.hasNoText(aCS);
    }

    public static boolean hasNoTextAfterTrim(@Nullable String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmptyAfterTrim(@Nullable String s) {
        return StringHelper.hasNoTextAfterTrim(s);
    }

    public static boolean hasText(@Nullable CharSequence aCS) {
        return aCS != null && aCS.length() > 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence aCS) {
        return StringHelper.hasText(aCS);
    }

    public static boolean hasTextAfterTrim(@Nullable String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isNotEmptyAfterTrim(@Nullable String s) {
        return StringHelper.hasTextAfterTrim(s);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Byte aValue, int nChars) {
        return aValue == null ? null : StringHelper.getLeadingZero((int)aValue.byteValue(), nChars);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Integer aValue, int nChars) {
        return aValue == null ? null : StringHelper.getLeadingZero(aValue.longValue(), nChars);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Long aValue, int nChars) {
        return aValue == null ? null : StringHelper.getLeadingZero((long)aValue, nChars);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Short aValue, int nChars) {
        return aValue == null ? null : StringHelper.getLeadingZero((int)aValue.shortValue(), nChars);
    }

    @Nonnull
    public static String getLeadingZero(int nValue, int nChars) {
        boolean bNeg = nValue < 0;
        String sValue = Integer.toString(MathHelper.abs(nValue));
        if (sValue.length() >= nChars) {
            return bNeg ? '-' + sValue : sValue;
        }
        StringBuilder aSB = new StringBuilder((bNeg ? 1 : 0) + nChars);
        if (bNeg) {
            aSB.append('-');
        }
        for (int i = 0; i < nChars - sValue.length(); ++i) {
            aSB.append('0');
        }
        return aSB.append(sValue).toString();
    }

    @Nonnull
    public static String getLeadingZero(long nValue, int nChars) {
        boolean bNeg = nValue < 0L;
        String sValue = Long.toString(MathHelper.abs(nValue));
        if (sValue.length() >= nChars) {
            return bNeg ? '-' + sValue : sValue;
        }
        StringBuilder aSB = new StringBuilder((bNeg ? 1 : 0) + nChars);
        if (bNeg) {
            aSB.append('-');
        }
        for (int i = 0; i < nChars - sValue.length(); ++i) {
            aSB.append('0');
        }
        return aSB.append(sValue).toString();
    }

    @Nonnull
    public static String getLeadingZero(@Nonnull String sValue, int nChars) {
        int nLen = sValue.length();
        if (nLen >= nChars) {
            return sValue;
        }
        StringBuilder aSB = new StringBuilder(nChars);
        for (int i = 0; i < nChars - nLen; ++i) {
            aSB.append('0');
        }
        return aSB.append(sValue).toString();
    }

    public static char getHexChar(int n) {
        return Character.forDigit(n, 16);
    }

    @Nonnull
    public static String getHexEncoded(@Nonnull byte[] aInput) {
        if (aInput == null) {
            throw new NullPointerException("input");
        }
        return StringHelper.getHexEncoded(aInput, 0, aInput.length);
    }

    @Nonnull
    public static String getHexEncoded(@Nonnull byte[] aInput, int nOfs, int nLen) {
        if (aInput == null) {
            throw new NullPointerException("input");
        }
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aInput.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aInput.length);
        }
        StringBuilder aSB = new StringBuilder(nLen * 2);
        for (int i = nOfs; i < nOfs + nLen; ++i) {
            byte b = aInput[i];
            char c1 = StringHelper.getHexChar((b & 0xF0) >> 4);
            char c2 = StringHelper.getHexChar(b & 0xF);
            aSB.append(c1).append(c2);
        }
        return aSB.toString();
    }

    @CheckForSigned
    public static int getHexValue(@Nonnegative char c) {
        return Character.digit(c, 16);
    }

    public static int getHexByte(@Nonnegative char cHigh, @Nonnegative char cLow) {
        int nHex1 = StringHelper.getHexValue(cHigh);
        int nHex2 = StringHelper.getHexValue(cLow);
        return nHex1 < 0 || nHex2 < 0 ? -1 : nHex1 << 4 | nHex2;
    }

    @Nonnull
    public static byte[] getHexDecoded(@Nonnull String sInput) {
        if (sInput == null) {
            throw new NullPointerException("input");
        }
        return StringHelper.getHexDecoded(sInput.toCharArray());
    }

    @Nonnull
    public static byte[] getHexDecoded(@Nonnull char[] aInput) {
        if (aInput == null) {
            throw new NullPointerException("input");
        }
        if (aInput.length % 2 > 0) {
            throw new IllegalArgumentException("Passed chars have no even length: " + aInput.length);
        }
        byte[] ret = new byte[aInput.length / 2];
        int nRetIdx = 0;
        for (int i = 0; i < aInput.length; i += 2) {
            char c0 = aInput[i];
            char c1 = aInput[i + 1];
            int nHexByte = StringHelper.getHexByte(c0, c1);
            if (nHexByte == -1) {
                throw new IllegalArgumentException("Failed to convert '" + c0 + "' or '" + c1 + "' to a hex value!");
            }
            ret[nRetIdx++] = (byte)nHexByte;
        }
        return ret;
    }

    @Nonnull
    public static String getHexString(byte nValue) {
        return Integer.toString(nValue & 0xFF, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(byte nValue, int nDigits) {
        return StringHelper.getLeadingZero(StringHelper.getHexString(nValue), nDigits);
    }

    @Nonnull
    public static String getHexString(int nValue) {
        return Integer.toString(nValue, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(int nValue, int nDigits) {
        return StringHelper.getLeadingZero(StringHelper.getHexString(nValue), nDigits);
    }

    @Nonnull
    public static String getHexString(long nValue) {
        return Long.toString(nValue, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(long nValue, int nDigits) {
        return StringHelper.getLeadingZero(StringHelper.getHexString(nValue), nDigits);
    }

    @Nonnull
    public static String getHexString(short nValue) {
        return Integer.toString(nValue & 0xFFFF, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(short nValue, int nDigits) {
        return StringHelper.getLeadingZero(StringHelper.getHexString(nValue), nDigits);
    }

    @Nonnegative
    public static int getLeadingWhitespaceCount(@Nullable String s) {
        int ret;
        if (s != null) {
            int nMax = s.length();
            for (ret = 0; ret < nMax && Character.isWhitespace(s.charAt(ret)); ++ret) {
            }
        }
        return ret;
    }

    @Nonnegative
    public static int getTrailingWhitespaceCount(@Nullable String s) {
        int ret = 0;
        if (s != null) {
            for (int nLast = s.length() - 1; nLast >= 0 && Character.isWhitespace(s.charAt(nLast)); --nLast) {
                ++ret;
            }
        }
        return ret;
    }

    @Nonnegative
    public static int getLeadingCharCount(@Nullable String s, char c) {
        int ret;
        if (s != null) {
            int nMax = s.length();
            for (ret = 0; ret < nMax && s.charAt(ret) == c; ++ret) {
            }
        }
        return ret;
    }

    @Nonnegative
    public static int getTrailingCharCount(@Nullable String s, char c) {
        int ret = 0;
        if (s != null) {
            for (int nLast = s.length() - 1; nLast >= 0 && s.charAt(nLast) == c; --nLast) {
                ++ret;
            }
        }
        return ret;
    }

    @Nonnull
    public static String getImploded(@Nonnull String sSep, @Nullable Iterable<?> aElements) {
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        StringBuilder aSB = new StringBuilder();
        if (aElements != null) {
            int nIndex = 0;
            for (Object aElement : aElements) {
                if (nIndex++ > 0) {
                    aSB.append(sSep);
                }
                aSB.append(aElement);
            }
        }
        return aSB.toString();
    }

    @Nonnull
    public static String getImploded(char cSep, @Nullable Iterable<?> aElements) {
        return StringHelper.getImploded(Character.toString(cSep), aElements);
    }

    @Nonnull
    public static String getImploded(@Nonnull String sSepOuter, @Nonnull String sSepInner, @Nullable Map<?, ?> aElements) {
        if (sSepOuter == null) {
            throw new NullPointerException("outerSeparator");
        }
        if (sSepInner == null) {
            throw new NullPointerException("innerSeparator");
        }
        StringBuilder aSB = new StringBuilder();
        if (aElements != null) {
            int nIndex = 0;
            for (Map.Entry<?, ?> aElement : aElements.entrySet()) {
                if (nIndex++ > 0) {
                    aSB.append(sSepOuter);
                }
                aSB.append(aElement.getKey()).append(sSepInner).append(aElement.getValue());
            }
        }
        return aSB.toString();
    }

    @Nonnull
    public static String getImploded(char cSepOuter, char cSepInner, @Nullable Map<?, ?> aElements) {
        return StringHelper.getImploded(Character.toString(cSepOuter), Character.toString(cSepInner), aElements);
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nonnull String sSep, ELEMENTTYPE ... aElements) {
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        if (ArrayHelper.isEmpty(aElements)) {
            return "";
        }
        return StringHelper.getImploded(sSep, aElements, 0, aElements.length);
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(char cSep, ELEMENTTYPE ... aElements) {
        return StringHelper.getImploded(Character.toString(cSep), aElements);
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nonnull String sSep, @Nullable ELEMENTTYPE[] aElements, @Nonnegative int nOfs, @Nonnegative int nLen) {
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        if (nOfs < 0 || nLen < 0 || aElements != null && nOfs + nLen > aElements.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + ArrayHelper.getSize(aElements));
        }
        StringBuilder aSB = new StringBuilder();
        if (aElements != null) {
            for (int i = nOfs; i < nOfs + nLen; ++i) {
                ELEMENTTYPE sElement = aElements[i];
                if (i > nOfs) {
                    aSB.append(sSep);
                }
                aSB.append(sElement);
            }
        }
        return aSB.toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(char cSep, @Nullable ELEMENTTYPE[] aElements, @Nonnegative int nOfs, @Nonnegative int nLen) {
        return StringHelper.getImploded(Character.toString(cSep), aElements, nOfs, nLen);
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String sSep, @Nullable Iterable<String> aElements) {
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        StringBuilder aSB = new StringBuilder();
        if (aElements != null) {
            int nElementsAdded = 0;
            for (String sElement : aElements) {
                if (!StringHelper.hasText(sElement)) continue;
                if (nElementsAdded++ > 0) {
                    aSB.append(sSep);
                }
                aSB.append(sElement);
            }
        }
        return aSB.toString();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char cSep, @Nullable Iterable<String> aElements) {
        return StringHelper.getImplodedNonEmpty(Character.toString(cSep), aElements);
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String sSep, String ... aElements) {
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        if (ArrayHelper.isEmpty(aElements)) {
            return "";
        }
        return StringHelper.getImplodedNonEmpty(sSep, aElements, 0, aElements.length);
    }

    @Nonnull
    public static String getImplodedNonEmpty(char cSep, String ... aElements) {
        return StringHelper.getImplodedNonEmpty(Character.toString(cSep), aElements);
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String sSep, @Nullable String[] aElements, @Nonnegative int nOfs, @Nonnegative int nLen) {
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        if (nOfs < 0 || nLen < 0 || aElements != null && nOfs + nLen > aElements.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + ArrayHelper.getSize(aElements));
        }
        StringBuilder aSB = new StringBuilder();
        if (aElements != null) {
            int nElementsAdded = 0;
            for (int i = nOfs; i < nOfs + nLen; ++i) {
                String sElement = aElements[i];
                if (!StringHelper.hasText(sElement)) continue;
                if (nElementsAdded++ > 0) {
                    aSB.append(sSep);
                }
                aSB.append(sElement);
            }
        }
        return aSB.toString();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char cSep, @Nullable String[] aElements, @Nonnegative int nOfs, @Nonnegative int nLen) {
        return StringHelper.getImplodedNonEmpty(Character.toString(cSep), aElements, nOfs, nLen);
    }

    @Nonnull
    public static String[] getExplodedArray(char cSep, @Nullable String sElements, int nMaxItems) {
        int nMatchIndex;
        if (nMaxItems == 1) {
            return new String[]{sElements};
        }
        if (StringHelper.hasNoText(sElements)) {
            return new String[0];
        }
        int nMaxResultElements = 1 + StringHelper.getCharCount(sElements, cSep);
        if (nMaxResultElements == 1) {
            return new String[]{sElements};
        }
        String[] ret = new String[nMaxItems < 1 ? nMaxResultElements : Math.min(nMaxResultElements, nMaxItems)];
        int nStartIndex = 0;
        int nItemsAdded = 0;
        while ((nMatchIndex = sElements.indexOf(cSep, nStartIndex)) >= 0) {
            ret[nItemsAdded++] = sElements.substring(nStartIndex, nMatchIndex);
            nStartIndex = nMatchIndex + 1;
            if (nMaxItems <= 0 || nItemsAdded != nMaxItems - 1) continue;
        }
        ret[nItemsAdded++] = sElements.substring(nStartIndex);
        if (nItemsAdded != ret.length) {
            throw new IllegalStateException("Added " + nItemsAdded + " but expected " + ret.length);
        }
        return ret;
    }

    @Nonnull
    public static String[] getExplodedArray(char cSep, @Nullable String sElements) {
        return StringHelper.getExplodedArray(cSep, sElements, -1);
    }

    @Nonnull
    public static <COLLTYPE extends Collection<String>> COLLTYPE getExploded(char cSep, @Nullable String sElements, int nMaxItems, @Nonnull COLLTYPE aCollection) {
        if (aCollection == null) {
            throw new NullPointerException("collection");
        }
        if (nMaxItems == 1) {
            aCollection.add((String)sElements);
        } else if (StringHelper.hasText(sElements)) {
            int nMatchIndex;
            int nStartIndex = 0;
            int nItemsAdded = 0;
            while ((nMatchIndex = sElements.indexOf(cSep, nStartIndex)) >= 0) {
                aCollection.add((String)sElements.substring(nStartIndex, nMatchIndex));
                nStartIndex = nMatchIndex + 1;
                if (nMaxItems <= 0 || ++nItemsAdded != nMaxItems - 1) continue;
            }
            aCollection.add((String)sElements.substring(nStartIndex));
        }
        return aCollection;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(char cSep, @Nullable String sElements) {
        return StringHelper.getExploded(cSep, sElements, -1);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(char cSep, @Nullable String sElements, int nMaxItems) {
        return StringHelper.getExploded(cSep, sElements, nMaxItems, nMaxItems >= 1 ? new ArrayList(nMaxItems) : new ArrayList());
    }

    @Nonnull
    public static <COLLTYPE extends Collection<String>> COLLTYPE getExploded(@Nonnull String sSep, @Nullable String sElements, int nMaxItems, @Nonnull COLLTYPE aCollection) {
        if (sSep == null) {
            throw new NullPointerException("separator");
        }
        if (aCollection == null) {
            throw new NullPointerException("collection");
        }
        if (nMaxItems == 1) {
            aCollection.add((String)sElements);
        } else {
            if (sSep.length() == 1) {
                return StringHelper.getExploded(sSep.charAt(0), sElements, nMaxItems, aCollection);
            }
            if (StringHelper.hasText(sElements)) {
                int nMatchIndex;
                int nStartIndex = 0;
                int nItemsAdded = 0;
                while ((nMatchIndex = sElements.indexOf(sSep, nStartIndex)) >= 0) {
                    aCollection.add((String)sElements.substring(nStartIndex, nMatchIndex));
                    nStartIndex = nMatchIndex + sSep.length();
                    if (nMaxItems <= 0 || ++nItemsAdded != nMaxItems - 1) continue;
                }
                aCollection.add((String)sElements.substring(nStartIndex));
            }
        }
        return aCollection;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(@Nonnull String sSep, @Nullable String sElements) {
        return StringHelper.getExploded(sSep, sElements, -1);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(@Nonnull String sSep, @Nullable String sElements, int nMaxItems) {
        return StringHelper.getExploded(sSep, sElements, nMaxItems, nMaxItems >= 1 ? new ArrayList(nMaxItems) : new ArrayList());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getExplodedToSet(@Nonnull String sSep, @Nullable String sElements) {
        return StringHelper.getExploded(sSep, sElements, -1, new HashSet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getExplodedToOrderedSet(@Nonnull String sSep, @Nullable String sElements) {
        return StringHelper.getExploded(sSep, sElements, -1, new LinkedHashSet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static SortedSet<String> getExplodedToSortedSet(@Nonnull String sSep, @Nullable String sElements) {
        return StringHelper.getExploded(sSep, sElements, -1, new TreeSet());
    }

    @Nonnull
    public static String getRepeated(char cElement, @Nonnegative int nRepeats) {
        if (nRepeats < 0) {
            throw new IllegalArgumentException("Repeat count must be >= 0.");
        }
        if (nRepeats == 0) {
            return "";
        }
        if (nRepeats == 1) {
            return Character.toString(cElement);
        }
        char[] aElement = new char[nRepeats];
        Arrays.fill(aElement, cElement);
        return new String(aElement);
    }

    @Nonnull
    public static String getRepeated(@Nonnull String sElement, @Nonnegative int nRepeats) {
        if (sElement == null) {
            throw new NullPointerException("element");
        }
        if (nRepeats < 0) {
            throw new IllegalArgumentException("Repeat count must be >= 0");
        }
        if (sElement.length() == 0 || nRepeats == 0) {
            return "";
        }
        if (nRepeats == 1) {
            return sElement;
        }
        if (sElement.length() == 1) {
            return StringHelper.getRepeated(sElement.charAt(0), nRepeats);
        }
        StringBuilder ret = new StringBuilder(sElement.length() * nRepeats);
        for (int i = 0; i < nRepeats; ++i) {
            ret.append(sElement);
        }
        return ret.toString();
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String sFront, @Nullable String sEnd) {
        if (sFront == null) {
            return sEnd == null ? "" : sEnd;
        }
        if (sEnd == null) {
            return sFront;
        }
        return sFront + sEnd;
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String sFront, @Nullable String sSep, @Nullable String sEnd) {
        StringBuilder aSB = new StringBuilder();
        if (StringHelper.hasText(sFront)) {
            aSB.append(sFront);
            if (StringHelper.hasText(sSep) && StringHelper.hasText(sEnd)) {
                aSB.append(sSep);
            }
        }
        if (StringHelper.hasText(sEnd)) {
            aSB.append(sEnd);
        }
        return aSB.toString();
    }

    public static boolean startsWith(@Nullable CharSequence aCS, char c) {
        return StringHelper.hasText(aCS) && aCS.charAt(0) == c;
    }

    public static boolean startsWithAny(@Nullable CharSequence aCS, @Nullable char[] aChars) {
        if (StringHelper.hasText(aCS) && aChars != null) {
            char cFirst = aCS.charAt(0);
            for (char c : aChars) {
                if (cFirst != c) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(@Nullable CharSequence aCS, char c) {
        return StringHelper.hasText(aCS) && Character.toLowerCase(aCS.charAt(0)) == Character.toLowerCase(c);
    }

    public static boolean startsWith(@Nullable CharSequence aCS, @Nullable CharSequence aSearch) {
        return aCS != null && aSearch != null && aCS.length() >= aSearch.length() && aCS.subSequence(0, aSearch.length()).equals(aSearch);
    }

    public static boolean startsWithIgnoreCase(@Nullable String sStr, @Nullable String sSearch) {
        return sStr != null && sSearch != null && sStr.length() >= sSearch.length() && sStr.substring(0, sSearch.length()).equalsIgnoreCase(sSearch);
    }

    public static boolean endsWith(@Nullable CharSequence aCS, char c) {
        return StringHelper.hasText(aCS) && StringHelper.getLastChar(aCS) == c;
    }

    public static boolean endsWithAny(@Nullable CharSequence aCS, @Nullable char[] aChars) {
        if (StringHelper.hasText(aCS) && aChars != null) {
            char cLast = StringHelper.getLastChar(aCS);
            for (char c : aChars) {
                if (cLast != c) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean endsWith(@Nullable CharSequence aCS, @Nullable CharSequence aSearch) {
        return aCS != null && aSearch != null && aCS.length() >= aSearch.length() && aCS.subSequence(aCS.length() - aSearch.length(), aCS.length()).equals(aSearch);
    }

    public static boolean endsWithIgnoreCase(@Nullable CharSequence aCS, char c) {
        return StringHelper.hasText(aCS) && Character.toLowerCase(StringHelper.getLastChar(aCS)) == Character.toLowerCase(c);
    }

    public static boolean endsWithIgnoreCase(@Nullable String sStr, @Nullable String sSearch) {
        return sStr != null && sSearch != null && sStr.length() >= sSearch.length() && sStr.substring(sStr.length() - sSearch.length(), sStr.length()).equalsIgnoreCase(sSearch);
    }

    public static int getIndexOf(@Nullable String sText, @Nullable String sSearch) {
        return sText != null && sSearch != null && sText.length() >= sSearch.length() ? sText.indexOf(sSearch) : -1;
    }

    public static int getLastIndexOf(@Nullable String sText, @Nullable String sSearch) {
        return sText != null && sSearch != null && sText.length() >= sSearch.length() ? sText.lastIndexOf(sSearch) : -1;
    }

    public static int getIndexOf(@Nullable String sText, char cSearch) {
        return sText != null && sText.length() >= 1 ? sText.indexOf(cSearch) : -1;
    }

    public static int getLastIndexOf(@Nullable String sText, char cSearch) {
        return sText != null && sText.length() >= 1 ? sText.lastIndexOf(cSearch) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String sText, @Nullable String sSearch, @Nonnull Locale aSortLocale) {
        return sText != null && sSearch != null && sText.length() >= sSearch.length() ? sText.toLowerCase(aSortLocale).indexOf(sSearch.toLowerCase(aSortLocale)) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String sText, @Nullable String sSearch, @Nonnull Locale aSortLocale) {
        return sText != null && sSearch != null && sText.length() >= sSearch.length() ? sText.toLowerCase(aSortLocale).lastIndexOf(sSearch.toLowerCase(aSortLocale)) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String sText, char cSearch, @Nonnull Locale aSortLocale) {
        return sText != null && sText.length() >= 1 ? sText.toLowerCase(aSortLocale).indexOf(Character.toLowerCase(cSearch)) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String sText, char cSearch, @Nonnull Locale aSortLocale) {
        return sText != null && sText.length() >= 1 ? sText.toLowerCase(aSortLocale).lastIndexOf(Character.toLowerCase(cSearch)) : -1;
    }

    public static boolean contains(@Nullable String sText, @Nullable String sSearch) {
        return StringHelper.getIndexOf(sText, sSearch) != -1;
    }

    public static boolean contains(@Nullable String sText, char cSearch) {
        return StringHelper.getIndexOf(sText, cSearch) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String sText, @Nullable String sSearch, @Nonnull Locale aSortLocale) {
        return StringHelper.getIndexOfIgnoreCase(sText, sSearch, aSortLocale) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String sText, char cSearch, @Nonnull Locale aSortLocale) {
        return StringHelper.getIndexOfIgnoreCase(sText, cSearch, aSortLocale) != -1;
    }

    public static boolean containsAny(@Nullable char[] aInput, @Nonnull char[] aSearchChars) {
        if (aSearchChars == null) {
            throw new NullPointerException("searchChars");
        }
        if (aInput != null) {
            for (char cIn : aInput) {
                if (!ArrayHelper.contains(aSearchChars, cIn)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(@Nullable String sInput, @Nonnull char[] aSearchChars) {
        return sInput == null ? false : StringHelper.containsAny(sInput.toCharArray(), aSearchChars);
    }

    @Nonnegative
    public static int getOccurrenceCount(@Nullable String sText, @Nullable String sSearch) {
        int ret = 0;
        int nTextLength = StringHelper.getLength(sText);
        int nSearchLength = StringHelper.getLength(sSearch);
        if (nTextLength > 0 && nSearchLength > 0 && nTextLength >= nSearchLength) {
            int nIndex;
            int nLastIndex = 0;
            do {
                if ((nIndex = StringHelper.getIndexOf(sText.substring(nLastIndex), sSearch)) == -1) continue;
                ++ret;
                nLastIndex += nIndex + nSearchLength;
            } while (nIndex != -1);
        }
        return ret;
    }

    @Nonnegative
    public static int getOccurrenceCountIgnoreCase(@Nullable String sText, @Nullable String sSearch, @Nonnull Locale aSortLocale) {
        return sText != null && sSearch != null ? StringHelper.getOccurrenceCount(sText.toLowerCase(aSortLocale), sSearch.toLowerCase(aSortLocale)) : 0;
    }

    @Nullable
    @CheckReturnValue
    public static String trimLeadingWhitespaces(@Nullable String s) {
        int n = StringHelper.getLeadingWhitespaceCount(s);
        return n == 0 ? s : s.substring(n, s.length());
    }

    @Nullable
    @CheckReturnValue
    public static String trimTrailingWhitespaces(@Nullable String s) {
        int n = StringHelper.getTrailingWhitespaceCount(s);
        return n == 0 ? s : s.substring(0, s.length() - n);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStart(@Nullable String sSrc, @Nullable String sLead) {
        return StringHelper.startsWith((CharSequence)sSrc, sLead) ? sSrc.substring(sLead.length(), sSrc.length()) : sSrc;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEnd(@Nullable String sSrc, @Nullable String sTail) {
        return StringHelper.endsWith((CharSequence)sSrc, sTail) ? sSrc.substring(0, sSrc.length() - sTail.length()) : sSrc;
    }

    @Nullable
    @CheckReturnValue
    public static String trim(@Nullable String s) {
        return StringHelper.hasNoText(s) ? s : s.trim();
    }

    public static char getFirstChar(@Nullable CharSequence aCS) {
        return StringHelper.hasText(aCS) ? aCS.charAt(0) : (char)'\u0000';
    }

    public static char getFirstChar(@Nullable char[] aChars) {
        return ArrayHelper.getFirst(aChars, '\u0000');
    }

    public static char getLastChar(@Nullable CharSequence aCS) {
        int nLength = StringHelper.getLength(aCS);
        return nLength > 0 ? aCS.charAt(nLength - 1) : (char)'\u0000';
    }

    public static char getLastChar(@Nullable char[] aChars) {
        return ArrayHelper.getLast(aChars, '\u0000');
    }

    @Nonnegative
    public static int getCharCount(@Nullable String s, char cSearch) {
        return s == null ? 0 : StringHelper.getCharCount(s.toCharArray(), cSearch);
    }

    @Nonnegative
    public static int getCharCount(@Nullable char[] aChars, char cSearch) {
        int ret = 0;
        if (aChars != null) {
            for (char c : aChars) {
                if (c != cSearch) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Nonnegative
    public static int getLineCount(@Nullable String s) {
        return StringHelper.getLineCount(s, '\n');
    }

    @Nonnegative
    public static int getLineCount(@Nullable String s, char cLineSep) {
        return 1 + StringHelper.getCharCount(s, cLineSep);
    }

    @Nonnegative
    public static int getCharacterCount(int nValue) {
        int nPrefix = nValue < 0 ? 2 : 1;
        int nRealValue = MathHelper.abs(nValue);
        int nIndex = 0;
        while (nRealValue > s_aSizeTableInt[nIndex]) {
            ++nIndex;
        }
        return nPrefix + nIndex;
    }

    @Nonnegative
    public static int getCharacterCount(long nValue) {
        int nPrefix = nValue < 0L ? 2 : 1;
        long nRealValue = MathHelper.abs(nValue);
        int nIndex = 0;
        while (nRealValue > s_aSizeTableLong[nIndex]) {
            ++nIndex;
        }
        return nPrefix + nIndex;
    }

    @Nonnull
    public static String getCutAfterLength(@Nonnull String sValue, @Nonnegative int nMaxLength, @Nullable String sNewSuffix) {
        if (sValue == null) {
            throw new NullPointerException("value");
        }
        if (nMaxLength < 0) {
            throw new IllegalArgumentException("Illegal max length");
        }
        if (sValue.length() <= nMaxLength) {
            return sValue;
        }
        if (StringHelper.isEmpty(sNewSuffix)) {
            return sValue.substring(0, nMaxLength);
        }
        return sValue.substring(0, nMaxLength) + sNewSuffix;
    }

    public static String replaceAllSafe(@Nullable String sInputString, @Nonnull String sSearchText, @Nullable CharSequence aReplacementText) {
        return StringHelper.replaceAll(sInputString, sSearchText, StringHelper.getNotNull(aReplacementText, (CharSequence)""));
    }

    @Nullable
    public static String replaceAll(@Nullable String sInputString, @Nonnull String sSearchText, @Nonnull CharSequence aReplacementText) {
        int nIndex;
        int nNewLength;
        if (StringHelper.hasNoText(sSearchText)) {
            throw new IllegalArgumentException("Value to replace may not be empty!");
        }
        if (aReplacementText == null) {
            throw new NullPointerException("newText");
        }
        if (StringHelper.hasNoText(sInputString)) {
            return sInputString;
        }
        int nOldLength = sSearchText.length();
        if (nOldLength == (nNewLength = aReplacementText.length())) {
            if (sSearchText.equals(aReplacementText)) {
                return sInputString;
            }
            if (nOldLength == 1) {
                return StringHelper.replaceAll(sInputString, sSearchText.charAt(0), aReplacementText.charAt(0));
            }
        }
        if ((nIndex = sInputString.indexOf(sSearchText, 0)) == -1) {
            return sInputString;
        }
        StringBuilder ret = new StringBuilder(nOldLength >= nNewLength ? sInputString.length() : sInputString.length() * 2);
        int nOldIndex = 0;
        do {
            ret.append(sInputString, nOldIndex, nIndex).append(aReplacementText);
            nOldIndex = nIndex += nOldLength;
        } while ((nIndex = sInputString.indexOf(sSearchText, nIndex)) != -1);
        ret.append(sInputString, nOldIndex, sInputString.length());
        return ret.toString();
    }

    @Nullable
    public static String replaceAll(@Nullable String sInputString, char cSearchChar, char cReplacementChar) {
        if (StringHelper.hasNoText(sInputString)) {
            return sInputString;
        }
        if (cSearchChar == cReplacementChar) {
            return sInputString;
        }
        int nIndex = sInputString.indexOf(cSearchChar, 0);
        if (nIndex == -1) {
            return sInputString;
        }
        StringBuilder ret = new StringBuilder(sInputString.length());
        int nOldIndex = 0;
        do {
            ret.append(sInputString, nOldIndex, nIndex).append(cReplacementChar);
            nOldIndex = ++nIndex;
        } while ((nIndex = sInputString.indexOf(cSearchChar, nIndex)) != -1);
        ret.append(sInputString, nOldIndex, sInputString.length());
        return ret.toString();
    }

    @Nullable
    public static String replaceAllRepeatedly(@Nullable String sInputString, @Nonnull String sSearchText, @Nonnull String sReplacementText) {
        String sLastLiteral;
        if (StringHelper.hasNoText(sSearchText)) {
            throw new IllegalArgumentException("searchText");
        }
        if (sReplacementText == null) {
            throw new NullPointerException("replacementText");
        }
        if (sReplacementText.indexOf(sSearchText) >= 0) {
            throw new IllegalArgumentException("Loop detection: replacementText must not contain searchText");
        }
        if (StringHelper.hasNoText(sInputString)) {
            return sInputString;
        }
        String sRet = sInputString;
        while (!(sLastLiteral = sRet).equals(sRet = StringHelper.replaceAll(sRet, sSearchText, sReplacementText))) {
        }
        return sRet;
    }

    public static int getReplaceMultipleResultLength(@Nonnull char[] aInputString, @Nonnull @Nonempty char[] aSearchChars, @Nonnull @Nonempty char[][] aReplacementStrings) {
        int nResultLen = 0;
        boolean bAnyReplacement = false;
        for (char cInput : aInputString) {
            int nReplacementLength = 1;
            for (int nIndex = 0; nIndex < aSearchChars.length; ++nIndex) {
                if (cInput != aSearchChars[nIndex]) continue;
                nReplacementLength = aReplacementStrings[nIndex].length;
                bAnyReplacement = true;
                break;
            }
            nResultLen += nReplacementLength;
        }
        return bAnyReplacement ? nResultLen : -1;
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable String sInputString, @Nonnull char[] aSearchChars, @Nonnull char[][] aReplacementStrings) {
        if (aSearchChars == null) {
            throw new NullPointerException("search");
        }
        if (aReplacementStrings == null) {
            throw new NullPointerException("replacements");
        }
        if (aSearchChars.length != aReplacementStrings.length) {
            throw new IllegalArgumentException("array length mismatch");
        }
        if (StringHelper.hasNoText(sInputString)) {
            return new char[0];
        }
        char[] aInput = sInputString.toCharArray();
        if (aSearchChars.length == 0) {
            return aInput;
        }
        int nResultLen = StringHelper.getReplaceMultipleResultLength(aInput, aSearchChars, aReplacementStrings);
        if (nResultLen == -1) {
            return aInput;
        }
        char[] aOutput = new char[nResultLen];
        int nOutputIndex = 0;
        for (char cInput : aInput) {
            boolean bFoundReplacement = false;
            for (int nPatternIndex = 0; nPatternIndex < aSearchChars.length; ++nPatternIndex) {
                if (cInput != aSearchChars[nPatternIndex]) continue;
                char[] aReplacement = aReplacementStrings[nPatternIndex];
                int nReplacementLength = aReplacement.length;
                System.arraycopy(aReplacement, 0, aOutput, nOutputIndex, nReplacementLength);
                nOutputIndex += nReplacementLength;
                bFoundReplacement = true;
                break;
            }
            if (bFoundReplacement) continue;
            aOutput[nOutputIndex++] = cInput;
        }
        return aOutput;
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable String sInputString, @Nonnull char[] aSearchChars, @Nonnull char[][] aReplacementStrings, @Nonnull Writer aTarget) throws IOException {
        if (aSearchChars == null) {
            throw new NullPointerException("patterns");
        }
        if (aReplacementStrings == null) {
            throw new NullPointerException("replacements");
        }
        if (aSearchChars.length != aReplacementStrings.length) {
            throw new IllegalArgumentException("array length mismatch");
        }
        if (aTarget == null) {
            throw new NullPointerException("target");
        }
        if (StringHelper.hasNoText(sInputString)) {
            return 0;
        }
        if (aSearchChars.length == 0) {
            aTarget.write(sInputString);
            return 0;
        }
        char[] aInput = sInputString.toCharArray();
        int nFirstNonReplace = 0;
        int nInputIndex = 0;
        int nTotalReplacements = 0;
        for (char cInput : aInput) {
            for (int nPatternIndex = 0; nPatternIndex < aSearchChars.length; ++nPatternIndex) {
                if (cInput != aSearchChars[nPatternIndex]) continue;
                if (nFirstNonReplace < nInputIndex) {
                    aTarget.write(aInput, nFirstNonReplace, nInputIndex - nFirstNonReplace);
                }
                nFirstNonReplace = nInputIndex + 1;
                aTarget.write(aReplacementStrings[nPatternIndex]);
                ++nTotalReplacements;
                break;
            }
            ++nInputIndex;
        }
        if (nFirstNonReplace < nInputIndex) {
            aTarget.write(aInput, nFirstNonReplace, nInputIndex - nFirstNonReplace);
        }
        return nTotalReplacements;
    }

    @Nullable
    public static String replaceMultiple(@Nullable String sInputString, @Nullable Map<String, String> aTransTable) {
        if (StringHelper.hasNoText(sInputString) || aTransTable == null || aTransTable.isEmpty()) {
            return sInputString;
        }
        String sOutput = sInputString;
        for (Map.Entry<String, String> aEntry : aTransTable.entrySet()) {
            sOutput = StringHelper.replaceAll(sOutput, aEntry.getKey(), aEntry.getValue());
        }
        return sOutput;
    }

    @Nullable
    public static String replaceMultiple(@Nullable String sInputString, @Nullable String[] aSearchTexts, @Nullable String[] aReplacementTexts) {
        int nReplacementTextLength;
        if (StringHelper.hasNoText(sInputString)) {
            return sInputString;
        }
        int nSearchTextLength = aSearchTexts == null ? 0 : aSearchTexts.length;
        int n = nReplacementTextLength = aReplacementTexts == null ? 0 : aReplacementTexts.length;
        if (nSearchTextLength != nReplacementTextLength) {
            throw new IllegalArgumentException("Array length mismatch!");
        }
        if (nSearchTextLength == 0) {
            return sInputString;
        }
        String sOutput = sInputString;
        for (int nIndex = 0; nIndex < nSearchTextLength; ++nIndex) {
            sOutput = StringHelper.replaceAll(sOutput, aSearchTexts[nIndex], aReplacementTexts[nIndex]);
        }
        return sOutput;
    }

    @Nonnegative
    public static int getLength(@Nullable CharSequence aCS) {
        return aCS == null ? 0 : aCS.length();
    }

    @Nonnull
    public static String getNotNull(@Nullable String s) {
        return StringHelper.getNotNull(s, "");
    }

    @Nullable
    public static String getNotNull(@Nullable String s, String sDefaultIfNull) {
        return s == null ? sDefaultIfNull : s;
    }

    @Nonnull
    public static CharSequence getNotNull(@Nullable CharSequence s) {
        return StringHelper.getNotNull(s, (CharSequence)"");
    }

    @Nullable
    public static CharSequence getNotNull(@Nullable CharSequence s, CharSequence sDefaultIfNull) {
        return s == null ? sDefaultIfNull : s;
    }

    @Nonnull
    public static String getToString(@Nullable Object aObject) {
        return StringHelper.getToString(aObject, "");
    }

    @Nullable
    public static String getToString(@Nullable Object aObject, @Nullable String sNullValue) {
        return aObject == null ? sNullValue : aObject.toString();
    }

    @Nonnull
    public static String getWithoutLeadingChar(@Nullable String sStr) {
        return StringHelper.getWithoutLeadingChars(sStr, 1);
    }

    @Nonnull
    public static String getWithoutLeadingChars(@Nullable String sStr, @Nonnegative int nCount) {
        if (nCount < 0) {
            throw new IllegalArgumentException("Count may not be negative: " + nCount);
        }
        if (nCount == 0) {
            return sStr;
        }
        return StringHelper.getLength(sStr) <= nCount ? "" : sStr.substring(nCount);
    }

    @Nonnull
    public static String getWithoutTrailingChar(@Nullable String sStr) {
        return StringHelper.getWithoutTrailingChars(sStr, 1);
    }

    @Nonnull
    public static String getWithoutTrailingChars(@Nullable String sStr, @Nonnegative int nCount) {
        if (nCount < 0) {
            throw new IllegalArgumentException("Count may not be negative: " + nCount);
        }
        if (nCount == 0) {
            return sStr;
        }
        int nLength = StringHelper.getLength(sStr);
        return nLength <= nCount ? "" : sStr.substring(0, nLength - nCount);
    }

    @Nullable
    private static String _getUntilFirst(@Nullable String sStr, char cSearch, boolean bIncludingSearchChar) {
        int nIndex = StringHelper.getIndexOf(sStr, cSearch);
        return nIndex == -1 ? null : sStr.substring(0, nIndex + (bIncludingSearchChar ? 1 : 0));
    }

    @Nullable
    public static String getUntilFirstIncl(@Nullable String sStr, char cSearch) {
        return StringHelper._getUntilFirst(sStr, cSearch, true);
    }

    @Nullable
    public static String getUntilFirstExcl(@Nullable String sStr, char cSearch) {
        return StringHelper._getUntilFirst(sStr, cSearch, false);
    }

    @Nullable
    private static String _getUntilFirst(@Nullable String sStr, @Nullable String sSearch, boolean bIncludingSearchChar) {
        if (StringHelper.hasNoText(sSearch)) {
            return "";
        }
        int nIndex = StringHelper.getIndexOf(sStr, sSearch);
        return nIndex == -1 ? null : sStr.substring(0, nIndex + (bIncludingSearchChar ? sSearch.length() : 0));
    }

    @Nullable
    public static String getUntilFirstIncl(@Nullable String sStr, @Nullable String sSearch) {
        return StringHelper._getUntilFirst(sStr, sSearch, true);
    }

    @Nullable
    public static String getUntilFirstExcl(@Nullable String sStr, @Nullable String sSearch) {
        return StringHelper._getUntilFirst(sStr, sSearch, false);
    }

    @Nullable
    private static String _getUntilLast(@Nullable String sStr, char cSearch, boolean bIncludingSearchChar) {
        int nIndex = StringHelper.getLastIndexOf(sStr, cSearch);
        return nIndex == -1 ? null : sStr.substring(0, nIndex + (bIncludingSearchChar ? 1 : 0));
    }

    @Nullable
    public static String getUntilLastIncl(@Nullable String sStr, char cSearch) {
        return StringHelper._getUntilLast(sStr, cSearch, true);
    }

    @Nullable
    public static String getUntilLastExcl(@Nullable String sStr, char cSearch) {
        return StringHelper._getUntilLast(sStr, cSearch, false);
    }

    @Nullable
    private static String _getUntilLast(@Nullable String sStr, @Nullable String sSearch, boolean bIncludingSearchChar) {
        if (StringHelper.hasNoText(sSearch)) {
            return "";
        }
        int nIndex = StringHelper.getLastIndexOf(sStr, sSearch);
        return nIndex == -1 ? null : sStr.substring(0, nIndex + (bIncludingSearchChar ? sSearch.length() : 0));
    }

    @Nullable
    public static String getUntilLastIncl(@Nullable String sStr, @Nullable String sSearch) {
        return StringHelper._getUntilLast(sStr, sSearch, true);
    }

    @Nullable
    public static String getUntilLastExcl(@Nullable String sStr, @Nullable String sSearch) {
        return StringHelper._getUntilLast(sStr, sSearch, false);
    }

    @Nullable
    private static String _getFromFirst(@Nullable String sStr, char cSearch, boolean bIncludingSearchChar) {
        int nIndex = StringHelper.getIndexOf(sStr, cSearch);
        return nIndex == -1 ? null : sStr.substring(nIndex + (bIncludingSearchChar ? 0 : 1));
    }

    @Nullable
    public static String getFromFirstIncl(@Nullable String sStr, char cSearch) {
        return StringHelper._getFromFirst(sStr, cSearch, true);
    }

    @Nullable
    public static String getFromFirstExcl(@Nullable String sStr, char cSearch) {
        return StringHelper._getFromFirst(sStr, cSearch, false);
    }

    @Nullable
    private static String _getFromFirst(@Nullable String sStr, @Nullable String sSearch, boolean bIncludingSearchChar) {
        if (StringHelper.hasNoText(sSearch)) {
            return sStr;
        }
        int nIndex = StringHelper.getIndexOf(sStr, sSearch);
        return nIndex == -1 ? null : sStr.substring(nIndex + (bIncludingSearchChar ? 0 : sSearch.length()));
    }

    @Nullable
    public static String getFromFirstIncl(@Nullable String sStr, @Nullable String sSearch) {
        return StringHelper._getFromFirst(sStr, sSearch, true);
    }

    @Nullable
    public static String getFromFirstExcl(@Nullable String sStr, @Nullable String sSearch) {
        return StringHelper._getFromFirst(sStr, sSearch, false);
    }

    @Nullable
    private static String _getFromLast(@Nullable String sStr, char cSearch, boolean bIncludingSearchChar) {
        int nIndex = StringHelper.getLastIndexOf(sStr, cSearch);
        return nIndex == -1 ? null : sStr.substring(nIndex + (bIncludingSearchChar ? 0 : 1));
    }

    @Nullable
    public static String getFromLastIncl(@Nullable String sStr, char cSearch) {
        return StringHelper._getFromLast(sStr, cSearch, true);
    }

    @Nullable
    public static String getFromLastExcl(@Nullable String sStr, char cSearch) {
        return StringHelper._getFromLast(sStr, cSearch, false);
    }

    @Nullable
    private static String _getFromLast(@Nullable String sStr, @Nullable String sSearch, boolean bIncludingSearchChar) {
        if (StringHelper.hasNoText(sSearch)) {
            return sStr;
        }
        int nIndex = StringHelper.getLastIndexOf(sStr, sSearch);
        return nIndex == -1 ? null : sStr.substring(nIndex + (bIncludingSearchChar ? 0 : sSearch.length()));
    }

    @Nullable
    public static String getFromLastIncl(@Nullable String sStr, @Nullable String sSearch) {
        return StringHelper._getFromLast(sStr, sSearch, true);
    }

    @Nullable
    public static String getFromLastExcl(@Nullable String sStr, @Nullable String sSearch) {
        return StringHelper._getFromLast(sStr, sSearch, false);
    }
}

