/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.SystemProperties;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.name.IHasDisplayName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public enum EOperatingSystem implements IHasDisplayName
{
    AIX("AIX", true),
    FREEBSD("FreeBSD", true),
    HPUX("HP-UX", true),
    LINUX("Linux", true),
    MACOS("Mac OS X", true),
    SOLARIS("Solaris", true),
    WINDOWS("Windows", false),
    ZOS("z/OS", false),
    UNKNOWN("Unknown", false);

    private static volatile EOperatingSystem s_aInstance;
    private final String m_sDisplayName;
    private final boolean m_bUnixBased;

    private EOperatingSystem(String sDisplayName, boolean bUnixBased) {
        this.m_sDisplayName = sDisplayName;
        this.m_bUnixBased = bUnixBased;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    public boolean isUnixBased() {
        return this.m_bUnixBased;
    }

    public boolean isCurrentOS() {
        return this == EOperatingSystem.getCurrentOS();
    }

    @Nonnull
    public static EOperatingSystem forName(@Nullable String sOSName) {
        if (sOSName == null) {
            return UNKNOWN;
        }
        String sLowerName = sOSName.toLowerCase();
        if (sLowerName.contains("solaris") || sLowerName.contains("sunos")) {
            return SOLARIS;
        }
        if (sLowerName.contains("linux")) {
            return LINUX;
        }
        if (sLowerName.contains("hp-ux") || sLowerName.contains("hp ux") || sLowerName.contains("hpux")) {
            return HPUX;
        }
        if (sLowerName.contains("aix")) {
            return AIX;
        }
        if (sLowerName.contains("windows")) {
            return WINDOWS;
        }
        if (sLowerName.contains("freebsd") || sLowerName.contains("free bsd")) {
            return FREEBSD;
        }
        if (sLowerName.contains("macos") || sLowerName.contains("mac os")) {
            return MACOS;
        }
        if (sLowerName.contains("z/os")) {
            return ZOS;
        }
        return UNKNOWN;
    }

    @Nonnull
    public static EOperatingSystem getCurrentOS() {
        EOperatingSystem ret = s_aInstance;
        if (ret == null) {
            String sCurrentOSName = EOperatingSystem.getCurrentOSName();
            s_aInstance = ret = EOperatingSystem.forName(sCurrentOSName);
            if (ret == UNKNOWN) {
                LoggerFactory.getLogger(EOperatingSystem.class).error("Failed to resolve operating system from name '" + sCurrentOSName + "'!!!");
            }
        }
        return ret;
    }

    @Nullable
    public static String getCurrentOSName() {
        return SystemProperties.getOsName();
    }

    @Nullable
    public static String getCurrentOSVersion() {
        return SystemProperties.getOsVersion();
    }

    static {
        s_aInstance = null;
    }
}

