/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.rule;

import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.typeconvert.ITypeConverterRule;
import com.phloc.commons.typeconvert.TypeConverter;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRule;
import javax.annotation.Nonnull;

public abstract class AbstractTypeConverterRuleFixedSourceAnyDestination
extends AbstractTypeConverterRule {
    private final Class<?> m_aSrcClass;
    private Class<?> m_aEffectiveDstClass;

    public AbstractTypeConverterRuleFixedSourceAnyDestination(@Nonnull Class<?> aSrcClass) {
        super(ITypeConverterRule.ESubType.FIXED_SRC_ANY_DST);
        if (aSrcClass == null) {
            throw new NullPointerException("srcClass");
        }
        this.m_aSrcClass = aSrcClass;
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> aSrcClass, @Nonnull Class<?> aDstClass) {
        if (!this.m_aSrcClass.equals(aSrcClass)) {
            return false;
        }
        this.m_aEffectiveDstClass = aDstClass;
        return true;
    }

    @Nonnull
    protected abstract Object getInBetweenValue(@Nonnull Object var1);

    @Override
    public final Object convert(@Nonnull Object aSource) {
        return TypeConverter.convertIfNecessary(this.getInBetweenValue(aSource), this.m_aEffectiveDstClass);
    }

    @Nonnull
    public final Class<?> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("srcClass", this.m_aSrcClass.getName()).toString();
    }
}

