/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.url.ISimpleURL;
import com.phloc.commons.url.IURLData;
import com.phloc.commons.url.IURLProtocol;
import com.phloc.commons.url.URLProtocolRegistry;
import com.phloc.commons.url.URLUtils;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractSimpleURL
implements ISimpleURL {
    private final String m_sPath;
    protected Map<String, String> m_aParams;
    protected String m_sAnchor;

    public AbstractSimpleURL() {
        this("?", null, null);
    }

    public AbstractSimpleURL(@Nonnull String sHref) {
        this(URLUtils.getAsURLData(sHref));
    }

    public AbstractSimpleURL(@Nonnull String sHref, @Nullable Map<String, String> aParams) {
        this(sHref);
        if (!ContainerHelper.isEmpty(aParams)) {
            if (this.m_aParams == null) {
                this.m_aParams = new LinkedHashMap<String, String>();
            }
            this.m_aParams.putAll(aParams);
        }
    }

    public AbstractSimpleURL(@Nonnull String sHref, @Nullable Map<String, String> aParams, @Nullable String sAnchor) {
        this(sHref, aParams);
        if (sAnchor != null) {
            this.m_sAnchor = sAnchor;
        }
    }

    public AbstractSimpleURL(@Nonnull IURLData aURL) {
        if (aURL == null) {
            throw new NullPointerException("URL");
        }
        this.m_sPath = aURL.getPath();
        if (aURL.directGetParams() != null) {
            this.m_aParams = new LinkedHashMap<String, String>(aURL.directGetParams());
        }
        this.m_sAnchor = aURL.getAnchor();
    }

    @Override
    @Nullable
    public final IURLProtocol getProtocol() {
        return URLProtocolRegistry.getProtocol(this.m_sPath);
    }

    @Override
    public final boolean hasKnownProtocol() {
        return URLProtocolRegistry.hasKnownProtocol(this.m_sPath);
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_sPath;
    }

    @Override
    public final boolean hasParams() {
        return !ContainerHelper.isEmpty(this.m_aParams);
    }

    @Override
    @Nonnegative
    public final int getParamCount() {
        return ContainerHelper.getSize(this.m_aParams);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject(reason="design")
    public final Map<String, String> directGetParams() {
        return this.m_aParams;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final Map<String, String> getAllParams() {
        return ContainerHelper.newOrderedMap(this.m_aParams);
    }

    @Override
    public final boolean hasAnchor() {
        return StringHelper.hasText(this.m_sAnchor);
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_sAnchor;
    }

    @Override
    @Nullable
    public final String getParam(@Nullable String sKey) {
        return this.m_aParams == null ? null : this.m_aParams.get(sKey);
    }

    @Override
    @Nonnull
    public final String getAsString() {
        return URLUtils.getURLString((IURLData)this, (String)null);
    }

    @Override
    @Nonnull
    public final String getAsStringWithEncodedParameters() {
        return this.getAsStringWithEncodedParameters("UTF-8");
    }

    @Override
    @Nonnull
    public final String getAsStringWithEncodedParameters(@Nonnull String sParameterCharset) {
        if (sParameterCharset == null) {
            throw new NullPointerException("parameterCharset");
        }
        return URLUtils.getURLString((IURLData)this, sParameterCharset);
    }

    @Override
    @Nonnull
    public final String getAsStringWithEncodedParameters(@Nonnull Charset aParameterCharset) {
        if (aParameterCharset == null) {
            throw new NullPointerException("parameterCharset");
        }
        return URLUtils.getURLString((IURLData)this, aParameterCharset);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractSimpleURL rhs = (AbstractSimpleURL)o;
        return this.m_sPath.equals(rhs.m_sPath) && EqualsUtils.equals(this.m_aParams, rhs.m_aParams) && EqualsUtils.equals(this.m_sAnchor, rhs.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append((Map)this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("path", this.m_sPath).appendIfNotNull("params", this.m_aParams).appendIfNotNull("anchor", this.m_sAnchor).toString();
    }
}

