/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSMediaRule
implements ICSSTopLevelRule {
    private final List<CSSMediaQuery> m_aMediaQueries = new ArrayList<CSSMediaQuery>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();

    public void addMediaQuery(@Nonnull @Nonempty CSSMediaQuery aMediaQuery) {
        if (aMediaQuery == null) {
            throw new NullPointerException("mediaQuery");
        }
        this.m_aMediaQueries.add(aMediaQuery);
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnull CSSMediaQuery aMediaQuery) {
        return EChange.valueOf((boolean)this.m_aMediaQueries.remove(aMediaQuery));
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int nMediumIndex) {
        if (nMediumIndex < 0 || nMediumIndex >= this.m_aMediaQueries.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.remove(nMediumIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaQuery> getAllMediaQueries() {
        return ContainerHelper.newList(this.m_aMediaQueries);
    }

    public void addRule(@Nonnull ICSSTopLevelRule aRule) {
        if (aRule == null) {
            throw new NullPointerException("rule");
        }
        this.m_aRules.add(aRule);
    }

    @Nonnull
    public EChange removeRule(@Nonnull ICSSTopLevelRule aRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(aRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int nRuleIndex) {
        if (nRuleIndex < 0 || nRuleIndex >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(nRuleIndex);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        if (!aSettings.isWriteMediaRules()) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        int nRuleCount = this.m_aRules.size();
        if (aSettings.isRemoveUnnecessaryCode() && nRuleCount == 0) {
            return "";
        }
        StringBuilder aSB = new StringBuilder("@media ");
        boolean bFirst = true;
        for (CSSMediaQuery sMedium : this.m_aMediaQueries) {
            if (bFirst) {
                bFirst = false;
            } else {
                aSB.append(bOptimizedOutput ? "," : ", ");
            }
            aSB.append(sMedium.getAsCSSString(aSettings, nIndentLevel));
        }
        if (nRuleCount == 0) {
            aSB.append(bOptimizedOutput ? "{}" : " {}\n");
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {\n");
            bFirst = true;
            for (ICSSTopLevelRule aRule : this.m_aRules) {
                String sRuleCSS = aRule.getAsCSSString(aSettings, nIndentLevel + 1);
                if (!StringHelper.hasText((CharSequence)sRuleCSS)) continue;
                if (bFirst) {
                    bFirst = false;
                } else if (!bOptimizedOutput) {
                    aSB.append('\n');
                }
                if (!bOptimizedOutput) {
                    aSB.append(aSettings.getIndent(nIndentLevel + 1));
                }
                aSB.append(sRuleCSS);
            }
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
            if (!bOptimizedOutput) {
                aSB.append('\n');
            }
        }
        return aSB.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSMediaRule)) {
            return false;
        }
        CSSMediaRule rhs = (CSSMediaRule)o;
        return ((Object)this.m_aMediaQueries).equals(rhs.m_aMediaQueries) && ((Object)this.m_aRules).equals(rhs.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMediaQueries).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("mediaQueries", this.m_aMediaQueries).append("styleRules", this.m_aRules).toString();
    }
}

