/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.utils;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.url.ISimpleURL;
import com.phloc.css.parser.ParseUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSURLHelper {
    public static final boolean DEFAULT_QUOTE_URLS = false;

    private CSSURLHelper() {
    }

    public static boolean isURLValue(@Nullable String sValue) {
        String sRealValue = StringHelper.trim((String)sValue);
        return StringHelper.getLength((CharSequence)sRealValue) > 5 && sRealValue.startsWith("url(") && sRealValue.endsWith(")");
    }

    @Nullable
    public static String getURLValue(@Nullable String sValue) {
        if (CSSURLHelper.isURLValue(sValue)) {
            String sRealValue = sValue.trim();
            String sStripped = sRealValue.substring("url(".length(), sRealValue.length() - 1);
            return ParseUtils.extractStringValue(sStripped);
        }
        return null;
    }

    @Nonnull
    @Deprecated
    @Nonempty
    public static String getAsCSSURL(@Nonnull ISimpleURL aURL) {
        return CSSURLHelper.getAsCSSURL(aURL, false);
    }

    @Nonnull
    @Nonempty
    public static String getAsCSSURL(@Nonnull ISimpleURL aURL, boolean bQuoteURL) {
        if (aURL == null) {
            throw new NullPointerException("URL");
        }
        return CSSURLHelper.getAsCSSURL(aURL.getAsString(), bQuoteURL);
    }

    @Nonnull
    @Deprecated
    @Nonempty
    public static String getAsCSSURL(@Nonnull @Nonempty String sURL) {
        return CSSURLHelper.getAsCSSURL(sURL, false);
    }

    @Nonnull
    @Nonempty
    public static String getAsCSSURL(@Nonnull @Nonempty String sURL, boolean bQuoteURL) {
        if (StringHelper.hasNoText((CharSequence)sURL)) {
            throw new IllegalArgumentException("passed URL is empty!");
        }
        if (bQuoteURL) {
            return "url('" + sURL + "')";
        }
        return "url(" + sURL + ')';
    }
}

