/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css;

import com.phloc.commons.CGlobal;
import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.lang.EnumHelper;
import com.phloc.commons.name.IHasName;
import com.phloc.css.ECSSMetaUnit;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import java.text.NumberFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSUnit implements IHasName,
ICSSVersionAware
{
    EM("em", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    EX("ex", ECSSMetaUnit.FONT_RELATIVE_LENGTH),
    PX("px", ECSSMetaUnit.ABSOLUTE_LENGTH),
    REM("rem", ECSSMetaUnit.FONT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VW("vw", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VH("vh", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    VMIN("vmin", ECSSMetaUnit.VIEWPORT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    CH("ch", ECSSMetaUnit.FONT_RELATIVE_LENGTH, ECSSVersion.CSS30),
    LENGTH_IN("in", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_CM("cm", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_MM("mm", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_PT("pt", ECSSMetaUnit.ABSOLUTE_LENGTH),
    LENGTH_PC("pc", ECSSMetaUnit.ABSOLUTE_LENGTH),
    PERCENTAGE("%", ECSSMetaUnit.PERCENTAGE),
    ANGLE_DEG("deg", ECSSMetaUnit.ANGLE),
    ANGLE_RAD("rad", ECSSMetaUnit.ANGLE),
    ANGLE_GRAD("grad", ECSSMetaUnit.ANGLE),
    ANGLE_TURN("turn", ECSSMetaUnit.ANGLE, ECSSVersion.CSS30),
    TIME_MS("ms", ECSSMetaUnit.TIME),
    TIME_S("s", ECSSMetaUnit.TIME),
    FREQ_HZ("hz", ECSSMetaUnit.FREQUENZY),
    FREQ_KHZ("khz", ECSSMetaUnit.FREQUENZY),
    DPI("dpi", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30),
    DPCM("dpcm", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30),
    DPPX("dppx", ECSSMetaUnit.RESOLUTION, ECSSVersion.CSS30);

    public static final ECSSUnit LENGTH_PX;
    private final String m_sName;
    private final ECSSMetaUnit m_eMetaUnit;
    private final ECSSVersion m_eVersion;

    private ECSSUnit(String sName, ECSSMetaUnit eMetaUnit) {
        this(sName, eMetaUnit, ECSSVersion.CSS21);
    }

    private ECSSUnit(@Nonnull String sName, ECSSMetaUnit eMetaUnit, ECSSVersion eVersion) {
        this.m_sName = sName;
        this.m_eMetaUnit = eMetaUnit;
        this.m_eVersion = eVersion;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    public ECSSMetaUnit getMetaUnit() {
        return this.m_eMetaUnit;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return this.m_eVersion;
    }

    @Nonnull
    @Nonempty
    public String format(int nValue) {
        return Integer.toString(nValue) + this.m_sName;
    }

    @Nonnull
    @Nonempty
    public String format(double dValue) {
        return NumberFormat.getNumberInstance(CGlobal.LOCALE_FIXED_NUMBER_FORMAT).format(dValue) + this.m_sName;
    }

    @Nullable
    public static ECSSUnit getFromNameOrNull(@Nullable String sName) {
        return (ECSSUnit)EnumHelper.getFromNameOrNull(ECSSUnit.class, (String)sName);
    }

    @Nonnull
    @Nonempty
    public static String em(int nValue) {
        return EM.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String em(double dValue) {
        return EM.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String ex(int nValue) {
        return EX.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String ex(double dValue) {
        return EX.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String px(int nValue) {
        return PX.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String px(double dValue) {
        return PX.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String rem(int nValue) {
        return REM.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String rem(double dValue) {
        return REM.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String vw(int nValue) {
        return VW.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String vw(double dValue) {
        return VW.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String vh(int nValue) {
        return VH.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String vh(double dValue) {
        return VH.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String vmin(int nValue) {
        return VMIN.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String vmin(double dValue) {
        return VMIN.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String ch(int nValue) {
        return CH.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String ch(double dValue) {
        return CH.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String in(int nValue) {
        return LENGTH_IN.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String in(double dValue) {
        return LENGTH_IN.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String cm(int nValue) {
        return LENGTH_CM.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String cm(double dValue) {
        return LENGTH_CM.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String mm(int nValue) {
        return LENGTH_MM.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String mm(double dValue) {
        return LENGTH_MM.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String pt(int nValue) {
        return LENGTH_PT.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String pt(double dValue) {
        return LENGTH_PT.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String pc(int nValue) {
        return LENGTH_PC.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String pc(double dValue) {
        return LENGTH_PC.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String perc(int nValue) {
        return PERCENTAGE.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String perc(double dValue) {
        return PERCENTAGE.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String deg(int nValue) {
        return ANGLE_DEG.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String deg(double dValue) {
        return ANGLE_DEG.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String rad(int nValue) {
        return ANGLE_RAD.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String rad(double dValue) {
        return ANGLE_RAD.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String grad(int nValue) {
        return ANGLE_GRAD.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String grad(double dValue) {
        return ANGLE_GRAD.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String turn(int nValue) {
        return ANGLE_TURN.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String turn(double dValue) {
        return ANGLE_TURN.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String ms(int nValue) {
        return TIME_MS.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String ms(double dValue) {
        return TIME_MS.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String s(int nValue) {
        return TIME_S.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String s(double dValue) {
        return TIME_S.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String hz(int nValue) {
        return FREQ_HZ.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String hz(double dValue) {
        return FREQ_HZ.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String khz(int nValue) {
        return FREQ_KHZ.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String khz(double dValue) {
        return FREQ_KHZ.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String dpi(int nValue) {
        return DPI.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String dpi(double dValue) {
        return DPI.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String dpcm(int nValue) {
        return DPCM.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String dpcm(double dValue) {
        return DPCM.format(dValue);
    }

    @Nonnull
    @Nonempty
    public static String dppx(int nValue) {
        return DPPX.format(nValue);
    }

    @Nonnull
    @Nonempty
    public static String dppx(double dValue) {
        return DPPX.format(dValue);
    }

    static {
        LENGTH_PX = PX;
    }
}

