/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.proxy;

import java.util.Date;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.proxy.ProxyFrame;

class Stats
extends HTTPFrame {
    ProxyFrame proxy = null;
    Date startdate = null;
    boolean hasICP = true;

    protected String percentage(int n, int n2) {
        double d = (double)n / (double)n2 * 100.0;
        return Integer.toString((int)d) + "%";
    }

    public Reply get(Request request) {
        Reply reply = this.createDefaultReply(request, 200);
        HtmlGenerator htmlGenerator = new HtmlGenerator("Proxy statistics");
        int n = this.proxy.reqcount + this.proxy.reqerred;
        if (n == 0) {
            n = 1;
        }
        htmlGenerator.addMeta("Refresh", "30");
        this.proxy.addStyleSheet(htmlGenerator);
        htmlGenerator.append("<h1>Proxy statistics</h1>");
        htmlGenerator.append("<p>The proxy was last started at: <em>" + this.startdate + "</em>");
        htmlGenerator.append("<p><table align=\"center\" border=\"1\"");
        htmlGenerator.append("<tr><th colspan=\"3\">Counter<th>count<th>percentage");
        htmlGenerator.append("<tr><td colspan=\"3\">Total number of handled requests");
        htmlGenerator.append("<td align=center>", Integer.toString(n));
        htmlGenerator.append("<td align=center>", this.percentage(n, n));
        htmlGenerator.append("<tr><td width=50><td colspan=\"2\">Erred requests");
        htmlGenerator.append("<td align=center>", Integer.toString(this.proxy.reqerred));
        htmlGenerator.append("<td align=center>", this.percentage(this.proxy.reqerred, n));
        htmlGenerator.append("<tr><td width=50><td colspan=\"2\">ICP redirects");
        htmlGenerator.append("<td align=center>", Integer.toString(this.proxy.cache_icps));
        htmlGenerator.append("<td align=center>", this.percentage(this.proxy.cache_icps, n));
        htmlGenerator.append("<tr><td width=50><td colspan=\"2\">Non cacheable");
        htmlGenerator.append("<td align=center>", Integer.toString(this.proxy.cache_nocache));
        htmlGenerator.append("<td align=center>", this.percentage(this.proxy.cache_nocache, n));
        int n2 = this.proxy.cache_hits + this.proxy.cache_misses + this.proxy.cache_revalidations + this.proxy.cache_retrievals;
        htmlGenerator.append("<tr><td width=50><td colspan=\"2\">Cache Accesses");
        htmlGenerator.append("<td align=center>", Integer.toString(n2));
        htmlGenerator.append("<td align=center>", this.percentage(n2, n));
        htmlGenerator.append("<tr><td width=50><td width=50><td>Hits (served by cache)");
        htmlGenerator.append("<td align=center>", Integer.toString(this.proxy.cache_hits));
        htmlGenerator.append("<td align=center>", this.percentage(this.proxy.cache_hits, n));
        htmlGenerator.append("<tr><td width=50><td width=50><td>Hits (revalidations)");
        htmlGenerator.append("<td align=center>", Integer.toString(this.proxy.cache_revalidations));
        htmlGenerator.append("<td align=center>", this.percentage(this.proxy.cache_revalidations, n));
        htmlGenerator.append("<tr><td width=50><td width=50><td>Misses (no entry)");
        htmlGenerator.append("<td align=center>", Integer.toString(this.proxy.cache_misses));
        htmlGenerator.append("<td align=center>", this.percentage(this.proxy.cache_misses, n));
        htmlGenerator.append("<tr><td width=50><td width=50><td>Misses (retrievals)");
        htmlGenerator.append("<td align=center>", Integer.toString(this.proxy.cache_retrievals));
        htmlGenerator.append("<td align=center>", this.percentage(this.proxy.cache_retrievals, n));
        htmlGenerator.append("</table>");
        htmlGenerator.append("<hr>Generated by <i>", this.proxy.getServer().getURL().toExternalForm());
        reply.setStream(htmlGenerator);
        reply.addPragma("no-cache");
        reply.setNoCache();
        return reply;
    }

    Stats(ProxyFrame proxyFrame) {
        this.proxy = proxyFrame;
        this.startdate = new Date(System.currentTimeMillis());
    }
}

