/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.util;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.util.PropertyMonitoring;

public class ObservableProperties
extends Properties {
    private static final boolean debug = false;
    PropertyMonitoring[] observers = new PropertyMonitoring[5];
    int observers_count = 0;

    public synchronized void registerObserver(PropertyMonitoring propertyMonitoring) {
        for (int i = 0; i < this.observers.length; ++i) {
            if (this.observers[i] != null) continue;
            this.observers[i] = propertyMonitoring;
            return;
        }
        if (this.observers_count + 1 >= this.observers.length) {
            PropertyMonitoring[] propertyMonitoringArray = new PropertyMonitoring[this.observers.length * 2];
            System.arraycopy(this.observers, 0, propertyMonitoringArray, 0, this.observers.length);
            this.observers = propertyMonitoringArray;
        }
        this.observers[this.observers_count++] = propertyMonitoring;
    }

    public synchronized boolean unregisterObserver(PropertyMonitoring propertyMonitoring) {
        for (int i = 0; i < this.observers.length; ++i) {
            if (this.observers[i] != propertyMonitoring) continue;
            this.observers[i] = null;
            return true;
        }
        return false;
    }

    public synchronized boolean putValue(String string, String string2) {
        if (string2 == null) {
            super.remove(string);
            return true;
        }
        String string3 = (String)this.get(string);
        if (string3 == null || !string3.equals(string2)) {
            super.put(string, string2);
            for (int i = 0; i < this.observers.length; ++i) {
                if (this.observers[i] == null || this.observers[i].propertyChanged(string)) continue;
                if (string3 != null) {
                    super.put(string, string3);
                }
                return false;
            }
        }
        return true;
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getProperty(string, null);
        if (string2 != null) {
            return "true".equalsIgnoreCase(string2);
        }
        return bl;
    }

    public String getString(String string, String string2) {
        String string3 = this.getProperty(string, null);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public String[] getStringArray(String string, String[] stringArray) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n = stringTokenizer.countTokens();
        String[] stringArray2 = new String[n];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringTokenizer.nextToken();
        }
        return stringArray2;
    }

    public int getInteger(String string, int n) {
        String string2 = this.getProperty(string, null);
        if (string2 != null) {
            try {
                if (string2.startsWith("0x")) {
                    return Integer.valueOf(string2.substring(2), 16);
                }
                if (string2.startsWith("#")) {
                    return Integer.valueOf(string2.substring(1), 16);
                }
                return Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public long getLong(String string, long l) {
        String string2 = this.getProperty(string, null);
        if (string2 != null) {
            try {
                return Long.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public double getDouble(String string, double d) {
        String string2 = this.getProperty(string, null);
        if (string2 != null) {
            try {
                return Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public File getFile(String string, File file) {
        String string2 = this.getProperty(string, null);
        if (string2 != null) {
            return new File(string2);
        }
        return file;
    }

    public ObservableProperties(Properties properties) {
        super(properties);
    }
}

