/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;

public class PDFNumsArray
extends PDFObject {
    protected SortedMap<Integer, Object> map = new TreeMap<Integer, Object>();

    public PDFNumsArray(PDFObject parent) {
        super(parent);
    }

    public int length() {
        return this.map.size();
    }

    public void put(Integer key, Object obj) {
        this.map.put(key, obj);
    }

    public void put(int key, Object obj) {
        this.put((Integer)key, obj);
    }

    public Object get(Integer key) {
        return this.map.get(key);
    }

    public Object get(int key) {
        return this.get((Integer)key);
    }

    public int output(OutputStream stream) throws IOException {
        CountingOutputStream cout = new CountingOutputStream(stream);
        StringBuilder textBuffer = new StringBuilder(64);
        textBuffer.append('[');
        boolean first = true;
        for (Map.Entry<Integer, Object> entry : this.map.entrySet()) {
            if (!first) {
                textBuffer.append(" ");
            }
            first = false;
            this.formatObject(entry.getKey(), (OutputStream)cout, textBuffer);
            textBuffer.append(" ");
            this.formatObject(entry.getValue(), (OutputStream)cout, textBuffer);
        }
        textBuffer.append(']');
        PDFDocument.flushTextBuffer(textBuffer, (OutputStream)cout);
        return cout.getCount();
    }
}

