/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.net.URL;
import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.CacheValidator;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.EntityCachedResource;

public class SimpleCacheValidator
extends CacheValidator {
    private static final boolean debug = false;

    public boolean checkStaleness(CachedResource cachedResource) {
        return cachedResource.getCurrentAge() >= cachedResource.getFreshnessLifetime();
    }

    public boolean isValid(CachedResource cachedResource, Request request) {
        int n;
        EntityCachedResource entityCachedResource = (EntityCachedResource)cachedResource.lookupResource(request);
        if (entityCachedResource == null || entityCachedResource.getWillRevalidate()) {
            return false;
        }
        if (request.getMaxAge() == 0) {
            entityCachedResource.setWillRevalidate(true);
            return false;
        }
        String[] stringArray = cachedResource.getVary();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("*")) {
                    return false;
                }
                ArrayDictionary arrayDictionary = cachedResource.getConnegHeaders();
                String string = null;
                String string2 = null;
                String string3 = null;
                if (arrayDictionary == null) {
                    return false;
                }
                string3 = stringArray[n].toLowerCase();
                string2 = (String)arrayDictionary.get(string3);
                string = request.getValue(stringArray[n]);
                if (string2 == null) {
                    if (string == null) continue;
                    return false;
                }
                if (string == null) {
                    return false;
                }
                if (string.equals(string2)) continue;
                return false;
            }
        }
        n = request.getMaxAge();
        int n2 = request.getMinFresh();
        int n3 = request.getMaxStale();
        int n4 = entityCachedResource.getCurrentAge();
        int n5 = entityCachedResource.getFreshnessLifetime();
        if (n == -1) {
            n = n5;
        }
        if (n4 < n) {
            return n2 == -1 || n4 + n2 <= n5;
        }
        return n3 != -1 && n2 == -1 && n4 < n + n3;
    }

    public void updateExpirationInfo(CachedResource cachedResource, Request request, Reply reply) {
        if (!(cachedResource instanceof EntityCachedResource)) {
            return;
        }
        EntityCachedResource entityCachedResource = (EntityCachedResource)cachedResource;
        long l = System.currentTimeMillis();
        int n = reply.getAge();
        long l2 = reply.getDate();
        entityCachedResource.setDate(l2);
        long l3 = request.getEmitDate();
        long l4 = l;
        if (l2 == -1L) {
            l2 = l / 2L + l3 / 2L;
        }
        int n2 = (int)Math.max(0L, (l4 - l2) / 1000L);
        int n3 = Math.max(n2, n);
        int n4 = (int)((l4 - l3) / 1000L);
        int n5 = n3 + n4;
        entityCachedResource.setInitialAge(n5);
        entityCachedResource.setResponseTime(l4);
        int n6 = -1;
        int n7 = reply.getSMaxAge();
        if (this.filter.isShared() && n7 != -1) {
            n6 = n7;
            entityCachedResource.setRevalidate(true);
        } else {
            int n8 = reply.getMaxAge();
            if (n8 < 0) {
                long l5 = reply.getExpires();
                if (l5 > 0L) {
                    n6 = (int)Math.max(0L, (l5 - l2) / 1000L);
                    if (n6 > 31536000 && reply.getMinorVersion() == 1 && reply.getMajorVersion() == 1) {
                        n6 = 31536000;
                    }
                } else if (reply.hasHeader(Reply.H_EXPIRES)) {
                    n6 = 0;
                } else if (reply.hasHeader(Reply.H_LAST_MODIFIED)) {
                    long l6 = reply.getLastModified();
                    int n9 = (int)Math.max(0L, (l - l6) / 1000L);
                    n6 = Math.min(86400, n9 / 10);
                } else {
                    int n10 = entityCachedResource.getFreshnessLifetime();
                    if (n10 == -1) {
                        URL uRL = request.getURL();
                        if (uRL != null) {
                            String string = uRL.toExternalForm();
                            n6 = string.indexOf(63) == -1 && string.indexOf("cgi") == -1 ? 300 : 0;
                        }
                    } else {
                        n6 = n10;
                    }
                }
            } else {
                n6 = n8;
            }
        }
        if (n6 != -1) {
            entityCachedResource.setFreshnessLifetime(n6);
        }
        if (reply.checkMustRevalidate()) {
            entityCachedResource.setRevalidate(true);
        } else if (this.filter.isShared() && reply.checkProxyRevalidate()) {
            entityCachedResource.setRevalidate(true);
        }
    }

    private void checkConsistency(CachedResource cachedResource, Request request, Reply reply) {
        long l;
        long l2;
        HttpEntityTag httpEntityTag;
        String string = cachedResource.getContentMD5();
        String string2 = reply.getContentMD5();
        if (string == null) {
            if (string2 != null) {
                cachedResource.setWillRevalidate(true);
            }
        } else if (string2 != null && !string2.equals(string)) {
            cachedResource.setWillRevalidate(true);
        }
        int n = cachedResource.getContentLength();
        int n2 = reply.getContentLength();
        if (n2 >= 0 && n != n2) {
            cachedResource.setWillRevalidate(true);
        }
        if ((httpEntityTag = reply.getETag()) != null) {
            String string3 = httpEntityTag.toString();
            String string4 = cachedResource.getETag();
            if (string4 == null || !string3.equals(string4)) {
                cachedResource.setWillRevalidate(true);
            }
        }
        if ((l2 = reply.getLastModified()) >= 0L && (l = cachedResource.getLastModified()) != l2) {
            cachedResource.setWillRevalidate(true);
        }
    }

    public void revalidateResource(CachedResource cachedResource, Request request, Reply reply) {
        cachedResource.setWillRevalidate(false);
        if (reply.getStatus() == 304) {
            this.updateExpirationInfo(cachedResource, request, reply);
        }
        this.checkConsistency(cachedResource, request, reply);
    }
}

