/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.cache;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.cache.ISimpleCache;
import com.phloc.commons.cache.SimpleCache;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.jmx.JMXUtils;
import com.phloc.commons.state.EChange;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCache<KEYTYPE, VALUETYPE>
implements ISimpleCache<KEYTYPE, VALUETYPE> {
    public static final boolean DEFAULT_JMX_ENABLED = false;
    public static final String STATISTICS_PREFIX = "cache:";
    private static final AtomicBoolean s_aJMXEnabled = new AtomicBoolean(false);
    protected final IStatisticsHandlerCache m_aCacheAccessStats;
    private final IStatisticsHandlerCounter m_aCacheRemoveStats;
    private final IStatisticsHandlerCounter m_aCacheClearStats;
    private final String m_sCacheName;
    private volatile Map<KEYTYPE, VALUETYPE> m_aCache;

    public AbstractCache(@Nonnull @Nonempty String sCacheName) {
        if (StringHelper.hasNoText(sCacheName)) {
            throw new IllegalArgumentException("cacheName");
        }
        this.m_aCacheAccessStats = StatisticsManager.getCacheHandler(STATISTICS_PREFIX + sCacheName + "$access");
        this.m_aCacheRemoveStats = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + sCacheName + "$remove");
        this.m_aCacheClearStats = StatisticsManager.getCounterHandler(STATISTICS_PREFIX + sCacheName + "$clear");
        this.m_sCacheName = sCacheName;
        if (AbstractCache.isJMXEnabled()) {
            JMXUtils.exposeMBeanWithAutoName(new SimpleCache(this), sCacheName);
        }
    }

    public static boolean isJMXEnabled() {
        return s_aJMXEnabled.get();
    }

    public static void setJMXEnabled(boolean bEnabled) {
        s_aJMXEnabled.set(bEnabled);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sCacheName;
    }

    @Nonnull
    @OverrideOnDemand
    protected Map<KEYTYPE, VALUETYPE> createCache() {
        return new WeakHashMap();
    }

    protected final void putInCache(@Nonnull KEYTYPE aKey, @Nonnull VALUETYPE aValue) {
        if (aKey == null) {
            throw new NullPointerException("cacheKey");
        }
        if (aValue == null) {
            throw new NullPointerException("cacheValue");
        }
        if (this.m_aCache == null) {
            this.m_aCache = this.createCache();
            if (this.m_aCache == null) {
                throw new IllegalStateException("No cache created!");
            }
        }
        this.m_aCache.put(aKey, aValue);
    }

    @Nullable
    @OverridingMethodsMustInvokeSuper
    protected final VALUETYPE getFromCacheNoStats(@Nullable KEYTYPE aKey) {
        return this.m_aCache == null ? null : (VALUETYPE)this.m_aCache.get(aKey);
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public VALUETYPE getFromCache(@Nullable KEYTYPE aKey) {
        VALUETYPE aValue = this.getFromCacheNoStats(aKey);
        if (aValue == null) {
            this.m_aCacheAccessStats.cacheMiss();
        } else {
            this.m_aCacheAccessStats.cacheHit();
        }
        return aValue;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange removeFromCache(@Nullable KEYTYPE aKey) {
        if (this.m_aCache == null || this.m_aCache.remove(aKey) == null) {
            return EChange.UNCHANGED;
        }
        this.m_aCacheRemoveStats.increment();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public EChange clearCache() {
        if (this.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aCache.clear();
        this.m_aCacheClearStats.increment();
        return EChange.CHANGED;
    }

    @Override
    @Nonnegative
    public int size() {
        return ContainerHelper.getSize(this.m_aCache);
    }

    @Override
    public boolean isEmpty() {
        return ContainerHelper.isEmpty(this.m_aCache);
    }

    public String toString() {
        return new ToStringGenerator(this).append("cacheName", this.m_sCacheName).append("content", this.m_aCache).toString();
    }
}

