/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.compare;

import com.phloc.commons.compare.CollatorUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CompareUtils {
    public static final boolean DEFAULT_NULL_VALUES_COME_FIRST = true;
    private static final CompareUtils s_aInstance = new CompareUtils();

    private CompareUtils() {
    }

    public static int compare(double d1, double d2) {
        return Double.compare(d1, d2);
    }

    public static int compare(float f1, float f2) {
        return Float.compare(f1, f2);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>> int nullSafeCompare(@Nullable DATATYPE aObj1, @Nullable DATATYPE aObj2) {
        return CompareUtils.nullSafeCompare(aObj1, aObj2, true);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>> int nullSafeCompare(@Nullable DATATYPE aObj1, @Nullable DATATYPE aObj2, boolean bNullValuesComeFirst) {
        return aObj1 == aObj2 ? 0 : (aObj1 == null ? (bNullValuesComeFirst ? -1 : 1) : (aObj2 == null ? (bNullValuesComeFirst ? 1 : -1) : aObj1.compareTo(aObj2)));
    }

    public static <DATATYPE> int nullSafeCompare(@Nullable DATATYPE aObj1, @Nullable DATATYPE aObj2, @Nonnull Comparator<DATATYPE> aComp) {
        return CompareUtils.nullSafeCompare(aObj1, aObj2, aComp, true);
    }

    public static <DATATYPE> int nullSafeCompare(@Nullable DATATYPE aObj1, @Nullable DATATYPE aObj2, @Nonnull Comparator<DATATYPE> aComp, boolean bNullValuesComeFirst) {
        return aObj1 == aObj2 ? 0 : (aObj1 == null ? (bNullValuesComeFirst ? -1 : 1) : (aObj2 == null ? (bNullValuesComeFirst ? 1 : -1) : aComp.compare(aObj1, aObj2)));
    }

    public static int nullSafeCompare(@Nullable String sStr1, @Nullable String sStr2, @Nonnull Locale aSortLocale) {
        return CompareUtils.nullSafeCompare(sStr1, sStr2, aSortLocale, true);
    }

    public static int nullSafeCompare(@Nullable String sStr1, @Nullable String sStr2, @Nonnull Locale aSortLocale, boolean bNullValuesComeFirst) {
        return CompareUtils.nullSafeCompare(sStr1, sStr2, CollatorUtils.getCollatorSpaceBeforeDot(aSortLocale), bNullValuesComeFirst);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static int nullSafeCompare(@Nullable String sStr1, @Nullable String sStr2, @Nonnull Collator aCollator) {
        return CompareUtils.nullSafeCompare(sStr1, sStr2, aCollator, true);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static int nullSafeCompare(@Nullable String sStr1, @Nullable String sStr2, @Nonnull Collator aCollator, boolean bNullValuesComeFirst) {
        return sStr1 == sStr2 ? 0 : (sStr1 == null ? (bNullValuesComeFirst ? -1 : 1) : (sStr2 == null ? (bNullValuesComeFirst ? 1 : -1) : aCollator.compare(sStr1, sStr2)));
    }
}

