/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.concurrent.collector;

import com.phloc.commons.callback.IThrowingRunnableWithParameter;
import com.phloc.commons.concurrent.collector.AbstractConcurrentCollector;
import com.phloc.commons.lang.GenericReflection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCollectorSingle<DATATYPE>
extends AbstractConcurrentCollector<DATATYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(ConcurrentCollectorSingle.class);
    private IThrowingRunnableWithParameter<DATATYPE> m_aPerformer;

    public ConcurrentCollectorSingle() {
        this(null);
    }

    public ConcurrentCollectorSingle(@Nullable IThrowingRunnableWithParameter<DATATYPE> aPerformer) {
        this(100, aPerformer);
    }

    public ConcurrentCollectorSingle(@Nonnegative int nMaxQueueSize, @Nullable IThrowingRunnableWithParameter<DATATYPE> aPerformer) {
        super(nMaxQueueSize);
        if (aPerformer != null) {
            this.setPerformer(aPerformer);
        }
    }

    protected final void setPerformer(@Nonnull IThrowingRunnableWithParameter<DATATYPE> aPerformer) {
        if (aPerformer == null) {
            throw new NullPointerException("performer");
        }
        this.m_aPerformer = aPerformer;
    }

    private void _executeCallback(DATATYPE aObject) {
        try {
            this.m_aPerformer.run(aObject);
        }
        catch (Throwable t) {
            s_aLogger.error("Failed to perform actions on object - object has been lost!", t);
        }
    }

    @Override
    public final void run() {
        if (this.m_aPerformer == null) {
            throw new IllegalStateException("No performer set!");
        }
        try {
            Object aCurrentObject;
            while ((aCurrentObject = this.m_aQueue.take()) != STOP_QUEUE_OBJECT) {
                this._executeCallback(GenericReflection.uncheckedCast(aCurrentObject));
            }
        }
        catch (Throwable t) {
            s_aLogger.error("Error taking elements from queue - queue has been interrupted!!!", t);
        }
    }
}

