/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IWritableResource;
import com.phloc.commons.io.IWritableResourceProvider;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.resource.ClassPathResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FileSystemResourceProvider
implements IWritableResourceProvider {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileSystemResourceProvider.class);
    private final File m_aBasePath;

    public FileSystemResourceProvider() {
        this((File)null);
    }

    public FileSystemResourceProvider(@Nonnull String sBasePath) {
        this(new File(sBasePath));
    }

    public FileSystemResourceProvider(@Nullable File aBasePath) {
        if (aBasePath != null) {
            if (!aBasePath.exists()) {
                throw new IllegalArgumentException("Passed base path '" + aBasePath + "' does not exist!");
            }
            if (!aBasePath.isDirectory()) {
                throw new IllegalArgumentException("Passed base path '" + aBasePath + "' is not a directory!");
            }
            if (!FileUtils.canRead(aBasePath)) {
                s_aLogger.warn("Cannot read passed base path '" + aBasePath + "'!");
            }
            if (!FileUtils.canWrite(aBasePath)) {
                s_aLogger.warn("Cannot write passed base path '" + aBasePath + "'!");
            }
            if (!FileUtils.canExecute(aBasePath)) {
                s_aLogger.warn("Cannot execute in passed base path '" + aBasePath + "'!");
            }
        }
        this.m_aBasePath = aBasePath;
    }

    @Nullable
    public File getBasePath() {
        return this.m_aBasePath;
    }

    @Nonnull
    private File _getFile(@Nonnull String sName) {
        if (sName == null) {
            throw new NullPointerException("name");
        }
        return this.m_aBasePath == null ? new File(sName) : new File(this.m_aBasePath, sName);
    }

    @Override
    public boolean supportsReading(@Nullable String sName) {
        if (ClassPathResource.isExplicitClassPathResource(sName)) {
            return false;
        }
        if (URLResource.isExplicitURLResource(sName)) {
            return false;
        }
        return StringHelper.hasText(sName) && this._getFile(sName).isAbsolute();
    }

    @Override
    public boolean supportsWriting(@Nullable String sName) {
        if (ClassPathResource.isExplicitClassPathResource(sName)) {
            return false;
        }
        if (URLResource.isExplicitURLResource(sName)) {
            return false;
        }
        return StringHelper.hasText(sName);
    }

    @Override
    @Nonnull
    public IReadableResource getReadableResource(@Nonnull String sName) {
        return new FileSystemResource(this._getFile(sName));
    }

    @Override
    @Nonnull
    public IWritableResource getWritableResource(@Nonnull String sName) {
        return new FileSystemResource(this._getFile(sName));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSystemResourceProvider)) {
            return false;
        }
        FileSystemResourceProvider rhs = (FileSystemResourceProvider)o;
        return EqualsUtils.equals(this.m_aBasePath, rhs.m_aBasePath);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBasePath).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).appendIfNotNull("basePath", this.m_aBasePath).toString();
    }
}

