/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NonBlockingBufferedReader
extends Reader {
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;
    private static final int DEFAULT_EXPECTED_LINE_LENGTH = 80;
    private Reader m_aReader;
    private char[] m_aBuf;
    private int m_nChars;
    private int m_nNextCharIndex;
    private int m_nMarkedChar = -1;
    private int m_nReadAheadLimit = 0;
    private boolean m_bSkipLF = false;
    private boolean m_bMarkedSkipLF = false;

    public NonBlockingBufferedReader(@Nonnull Reader aReader) {
        this(aReader, 8192);
    }

    public NonBlockingBufferedReader(@Nonnull Reader aReader, @Nonnegative int nSize) {
        super((Object)aReader);
        if (nSize <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.m_aReader = aReader;
        this.m_aBuf = new char[nSize];
    }

    private void _ensureOpen() throws IOException {
        if (this.m_aReader == null) {
            throw new IOException("Stream closed");
        }
    }

    private void _fill() throws IOException {
        int nBytesRead;
        int nDstOfs = 0;
        if (this.m_nMarkedChar > -1) {
            int nDelta = this.m_nNextCharIndex - this.m_nMarkedChar;
            if (nDelta >= this.m_nReadAheadLimit) {
                this.m_nMarkedChar = -2;
                this.m_nReadAheadLimit = 0;
            } else {
                if (this.m_nReadAheadLimit <= this.m_aBuf.length) {
                    System.arraycopy(this.m_aBuf, this.m_nMarkedChar, this.m_aBuf, 0, nDelta);
                    this.m_nMarkedChar = 0;
                    nDstOfs = nDelta;
                } else {
                    char[] aNewBuf = new char[this.m_nReadAheadLimit];
                    System.arraycopy(this.m_aBuf, this.m_nMarkedChar, aNewBuf, 0, nDelta);
                    this.m_aBuf = aNewBuf;
                    this.m_nMarkedChar = 0;
                    nDstOfs = nDelta;
                }
                this.m_nNextCharIndex = this.m_nChars = nDelta;
            }
        }
        while ((nBytesRead = this.m_aReader.read(this.m_aBuf, nDstOfs, this.m_aBuf.length - nDstOfs)) == 0) {
        }
        if (nBytesRead > 0) {
            this.m_nChars = nDstOfs + nBytesRead;
            this.m_nNextCharIndex = nDstOfs;
        }
    }

    @Override
    public int read() throws IOException {
        this._ensureOpen();
        while (true) {
            if (this.m_nNextCharIndex >= this.m_nChars) {
                this._fill();
                if (this.m_nNextCharIndex >= this.m_nChars) {
                    return -1;
                }
            }
            if (!this.m_bSkipLF) break;
            this.m_bSkipLF = false;
            if (this.m_aBuf[this.m_nNextCharIndex] != '\n') break;
            ++this.m_nNextCharIndex;
        }
        return this.m_aBuf[this.m_nNextCharIndex++];
    }

    private int _internalRead(char[] aBuf, int nOfs, int nLen) throws IOException {
        if (this.m_nNextCharIndex >= this.m_nChars) {
            if (nLen >= this.m_aBuf.length && this.m_nMarkedChar <= -1 && !this.m_bSkipLF) {
                return this.m_aReader.read(aBuf, nOfs, nLen);
            }
            this._fill();
        }
        if (this.m_nNextCharIndex >= this.m_nChars) {
            return -1;
        }
        if (this.m_bSkipLF) {
            this.m_bSkipLF = false;
            if (this.m_aBuf[this.m_nNextCharIndex] == '\n') {
                ++this.m_nNextCharIndex;
                if (this.m_nNextCharIndex >= this.m_nChars) {
                    this._fill();
                }
                if (this.m_nNextCharIndex >= this.m_nChars) {
                    return -1;
                }
            }
        }
        int nBytesRead = Math.min(nLen, this.m_nChars - this.m_nNextCharIndex);
        System.arraycopy(this.m_aBuf, this.m_nNextCharIndex, aBuf, nOfs, nBytesRead);
        this.m_nNextCharIndex += nBytesRead;
        return nBytesRead;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n1;
        this._ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this._internalRead(cbuf, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && this.m_aReader.ready() && (n1 = this._internalRead(cbuf, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    @Nullable
    public String readLine() throws IOException {
        StringBuilder aSB = null;
        this._ensureOpen();
        boolean bOmitLF = this.m_bSkipLF;
        while (true) {
            int nIndex;
            if (this.m_nNextCharIndex >= this.m_nChars) {
                this._fill();
            }
            if (this.m_nNextCharIndex >= this.m_nChars) {
                if (aSB != null && aSB.length() > 0) {
                    return aSB.toString();
                }
                return null;
            }
            boolean bEOL = false;
            char cLast = '\u0000';
            if (!bOmitLF || this.m_aBuf[this.m_nNextCharIndex] == '\n') {
                // empty if block
            }
            this.m_bSkipLF = false;
            bOmitLF = false;
            for (nIndex = ++this.m_nNextCharIndex; nIndex < this.m_nChars; ++nIndex) {
                cLast = this.m_aBuf[nIndex];
                if (cLast != '\n' && cLast != '\r') continue;
                bEOL = true;
                break;
            }
            int nStartChar = this.m_nNextCharIndex;
            this.m_nNextCharIndex = nIndex;
            if (bEOL) {
                String sStr;
                if (aSB == null) {
                    sStr = new String(this.m_aBuf, nStartChar, nIndex - nStartChar);
                } else {
                    aSB.append(this.m_aBuf, nStartChar, nIndex - nStartChar);
                    sStr = aSB.toString();
                }
                ++this.m_nNextCharIndex;
                if (cLast == '\r') {
                    this.m_bSkipLF = true;
                }
                return sStr;
            }
            if (aSB == null) {
                aSB = new StringBuilder(80);
            }
            aSB.append(this.m_aBuf, nStartChar, nIndex - nStartChar);
        }
    }

    @Override
    public long skip(long nBytes) throws IOException {
        long nRest;
        long d;
        if (nBytes < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        this._ensureOpen();
        for (nRest = nBytes; nRest > 0L; nRest -= d) {
            if (this.m_nNextCharIndex >= this.m_nChars) {
                this._fill();
            }
            if (this.m_nNextCharIndex >= this.m_nChars) break;
            if (this.m_bSkipLF) {
                this.m_bSkipLF = false;
                if (this.m_aBuf[this.m_nNextCharIndex] == '\n') {
                    ++this.m_nNextCharIndex;
                }
            }
            if (nRest <= (d = (long)(this.m_nChars - this.m_nNextCharIndex))) {
                this.m_nNextCharIndex = (int)((long)this.m_nNextCharIndex + nRest);
                nRest = 0L;
                break;
            }
            this.m_nNextCharIndex = this.m_nChars;
        }
        return nBytes - nRest;
    }

    @Override
    public boolean ready() throws IOException {
        this._ensureOpen();
        if (this.m_bSkipLF) {
            if (this.m_nNextCharIndex >= this.m_nChars && this.m_aReader.ready()) {
                this._fill();
            }
            if (this.m_nNextCharIndex < this.m_nChars) {
                if (this.m_aBuf[this.m_nNextCharIndex] == '\n') {
                    ++this.m_nNextCharIndex;
                }
                this.m_bSkipLF = false;
            }
        }
        return this.m_nNextCharIndex < this.m_nChars || this.m_aReader.ready();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(@Nonnegative int nReadAheadLimit) throws IOException {
        if (nReadAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this._ensureOpen();
        this.m_nReadAheadLimit = nReadAheadLimit;
        this.m_nMarkedChar = this.m_nNextCharIndex;
        this.m_bMarkedSkipLF = this.m_bSkipLF;
    }

    @Override
    public void reset() throws IOException {
        this._ensureOpen();
        if (this.m_nMarkedChar < 0) {
            throw new IOException(this.m_nMarkedChar == -2 ? "Mark invalid" : "Stream not marked");
        }
        this.m_nNextCharIndex = this.m_nMarkedChar;
        this.m_bSkipLF = this.m_bMarkedSkipLF;
    }

    @Override
    public void close() throws IOException {
        if (this.m_aReader != null) {
            this.m_aReader.close();
            this.m_aReader = null;
            this.m_aBuf = null;
        }
    }
}

