/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.jmx.JMXUtils;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.IStatisticsHandlerKeyedSize;
import com.phloc.commons.stats.IStatisticsHandlerKeyedTimer;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsHandlerCache;
import com.phloc.commons.stats.StatisticsHandlerCounter;
import com.phloc.commons.stats.StatisticsHandlerKeyedCounter;
import com.phloc.commons.stats.StatisticsHandlerKeyedSize;
import com.phloc.commons.stats.StatisticsHandlerKeyedTimer;
import com.phloc.commons.stats.StatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsHandlerTimer;
import com.phloc.commons.string.StringHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StatisticsManager {
    public static final boolean DEFAULT_JMX_ENABLED = false;
    private static final AtomicBoolean s_aJMXEnabled = new AtomicBoolean(false);
    private static final ReadWriteLock s_aRWLockCache = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockTimer = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockKeyedTimer = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockSize = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockKeyedSize = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockCounter = new ReentrantReadWriteLock();
    private static final ReadWriteLock s_aRWLockKeyedCounter = new ReentrantReadWriteLock();
    private static final Map<String, StatisticsHandlerCache> s_aHdlCache = new HashMap<String, StatisticsHandlerCache>();
    private static final Map<String, StatisticsHandlerTimer> s_aHdlTimer = new HashMap<String, StatisticsHandlerTimer>();
    private static final Map<String, StatisticsHandlerKeyedTimer> s_aHdlKeyedTimer = new HashMap<String, StatisticsHandlerKeyedTimer>();
    private static final Map<String, StatisticsHandlerSize> s_aHdlSize = new HashMap<String, StatisticsHandlerSize>();
    private static final Map<String, StatisticsHandlerKeyedSize> s_aHdlKeyedSize = new HashMap<String, StatisticsHandlerKeyedSize>();
    private static final Map<String, StatisticsHandlerCounter> s_aHdlCounter = new HashMap<String, StatisticsHandlerCounter>();
    private static final Map<String, StatisticsHandlerKeyedCounter> s_aHdlKeyedCounter = new HashMap<String, StatisticsHandlerKeyedCounter>();
    private static final StatisticsManager s_aInstance = new StatisticsManager();

    private StatisticsManager() {
    }

    public static boolean isJMXEnabled() {
        return s_aJMXEnabled.get();
    }

    public static void setJMXEnabled(boolean bEnabled) {
        s_aJMXEnabled.set(bEnabled);
    }

    @Nonnull
    public static IStatisticsHandlerCache getCacheHandler(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return StatisticsManager.getCacheHandler(aClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerCache getCacheHandler(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        s_aRWLockCache.writeLock().lock();
        try {
            StatisticsHandlerCache aHdl = s_aHdlCache.get(sName);
            if (aHdl == null) {
                aHdl = new StatisticsHandlerCache();
                if (StatisticsManager.isJMXEnabled()) {
                    JMXUtils.exposeMBeanWithAutoName(aHdl, sName);
                }
                s_aHdlCache.put(sName, aHdl);
            }
            StatisticsHandlerCache statisticsHandlerCache = aHdl;
            return statisticsHandlerCache;
        }
        finally {
            s_aRWLockCache.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllCacheHandler() {
        s_aRWLockCache.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlCache.keySet());
            return set;
        }
        finally {
            s_aRWLockCache.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerTimer getTimerHandler(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return StatisticsManager.getTimerHandler(aClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerTimer getTimerHandler(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        s_aRWLockTimer.writeLock().lock();
        try {
            StatisticsHandlerTimer aHdl = s_aHdlTimer.get(sName);
            if (aHdl == null) {
                aHdl = new StatisticsHandlerTimer();
                if (StatisticsManager.isJMXEnabled()) {
                    JMXUtils.exposeMBeanWithAutoName(aHdl, sName);
                }
                s_aHdlTimer.put(sName, aHdl);
            }
            StatisticsHandlerTimer statisticsHandlerTimer = aHdl;
            return statisticsHandlerTimer;
        }
        finally {
            s_aRWLockTimer.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllTimerHandler() {
        s_aRWLockTimer.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlTimer.keySet());
            return set;
        }
        finally {
            s_aRWLockTimer.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerKeyedTimer getKeyedTimerHandler(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return StatisticsManager.getKeyedTimerHandler(aClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerKeyedTimer getKeyedTimerHandler(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        s_aRWLockKeyedTimer.writeLock().lock();
        try {
            StatisticsHandlerKeyedTimer aHdl = s_aHdlKeyedTimer.get(sName);
            if (aHdl == null) {
                aHdl = new StatisticsHandlerKeyedTimer();
                if (StatisticsManager.isJMXEnabled()) {
                    JMXUtils.exposeMBeanWithAutoName(aHdl, sName);
                }
                s_aHdlKeyedTimer.put(sName, aHdl);
            }
            StatisticsHandlerKeyedTimer statisticsHandlerKeyedTimer = aHdl;
            return statisticsHandlerKeyedTimer;
        }
        finally {
            s_aRWLockKeyedTimer.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllKeyedTimerHandler() {
        s_aRWLockKeyedTimer.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlKeyedTimer.keySet());
            return set;
        }
        finally {
            s_aRWLockKeyedTimer.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerSize getSizeHandler(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return StatisticsManager.getSizeHandler(aClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerSize getSizeHandler(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        s_aRWLockSize.writeLock().lock();
        try {
            StatisticsHandlerSize aHdl = s_aHdlSize.get(sName);
            if (aHdl == null) {
                aHdl = new StatisticsHandlerSize();
                if (StatisticsManager.isJMXEnabled()) {
                    JMXUtils.exposeMBeanWithAutoName(aHdl, sName);
                }
                s_aHdlSize.put(sName, aHdl);
            }
            StatisticsHandlerSize statisticsHandlerSize = aHdl;
            return statisticsHandlerSize;
        }
        finally {
            s_aRWLockSize.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllSizeHandler() {
        s_aRWLockSize.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlSize.keySet());
            return set;
        }
        finally {
            s_aRWLockSize.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerKeyedSize getKeyedSizeHandler(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return StatisticsManager.getKeyedSizeHandler(aClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerKeyedSize getKeyedSizeHandler(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        s_aRWLockKeyedSize.writeLock().lock();
        try {
            StatisticsHandlerKeyedSize aHdl = s_aHdlKeyedSize.get(sName);
            if (aHdl == null) {
                aHdl = new StatisticsHandlerKeyedSize();
                if (StatisticsManager.isJMXEnabled()) {
                    JMXUtils.exposeMBeanWithAutoName(aHdl, sName);
                }
                s_aHdlKeyedSize.put(sName, aHdl);
            }
            StatisticsHandlerKeyedSize statisticsHandlerKeyedSize = aHdl;
            return statisticsHandlerKeyedSize;
        }
        finally {
            s_aRWLockKeyedSize.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllKeyedSizeHandler() {
        s_aRWLockKeyedSize.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlKeyedSize.keySet());
            return set;
        }
        finally {
            s_aRWLockKeyedSize.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerCounter getCounterHandler(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return StatisticsManager.getCounterHandler(aClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerCounter getCounterHandler(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        s_aRWLockCounter.writeLock().lock();
        try {
            StatisticsHandlerCounter aHdl = s_aHdlCounter.get(sName);
            if (aHdl == null) {
                aHdl = new StatisticsHandlerCounter();
                if (StatisticsManager.isJMXEnabled()) {
                    JMXUtils.exposeMBeanWithAutoName(aHdl, sName);
                }
                s_aHdlCounter.put(sName, aHdl);
            }
            StatisticsHandlerCounter statisticsHandlerCounter = aHdl;
            return statisticsHandlerCounter;
        }
        finally {
            s_aRWLockCounter.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllCounterHandler() {
        s_aRWLockCounter.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlCounter.keySet());
            return set;
        }
        finally {
            s_aRWLockCounter.readLock().unlock();
        }
    }

    @Nonnull
    public static IStatisticsHandlerKeyedCounter getKeyedCounterHandler(@Nonnull Class<?> aClass) {
        if (aClass == null) {
            throw new NullPointerException("class");
        }
        return StatisticsManager.getKeyedCounterHandler(aClass.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static IStatisticsHandlerKeyedCounter getKeyedCounterHandler(@Nonnull @Nonempty String sName) {
        if (StringHelper.hasNoText(sName)) {
            throw new IllegalArgumentException("name");
        }
        s_aRWLockKeyedCounter.writeLock().lock();
        try {
            StatisticsHandlerKeyedCounter aHdl = s_aHdlKeyedCounter.get(sName);
            if (aHdl == null) {
                aHdl = new StatisticsHandlerKeyedCounter();
                if (StatisticsManager.isJMXEnabled()) {
                    JMXUtils.exposeMBeanWithAutoName(aHdl, sName);
                }
                s_aHdlKeyedCounter.put(sName, aHdl);
            }
            StatisticsHandlerKeyedCounter statisticsHandlerKeyedCounter = aHdl;
            return statisticsHandlerKeyedCounter;
        }
        finally {
            s_aRWLockKeyedCounter.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllKeyedCounterHandler() {
        s_aRWLockKeyedCounter.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aHdlKeyedCounter.keySet());
            return set;
        }
        finally {
            s_aRWLockKeyedCounter.readLock().unlock();
        }
    }
}

